// =====================================================================
//  $Id: OFFflatband.cc,v 1.1 2003/06/30 03:46:06 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "Trootinit.h"

#include "St01DarkDataSetInterface.hh"
#include "St01DarkDataSetList.hh"
#include "St01DarkDataSet.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <rcfile>" << Tendl;
    Tcerr << "format: TEMP[C] CYCLE[sec] FILE" << Tendl;
    return( -1 );
  }

  Tstring rcfile = argv[ 1 ];

  St01DarkDataSetInterface datasetif( rcfile );
  const St01DarkDataSetList& datasetlist = datasetif.GetDarkDataSetList();
  TdoubleList graphvoltage;

  for ( Tsize_t i = 0; i < datasetlist.size(); i ++ ) {

    //(VŰ)Υդ뤫
    Tdouble v = datasetlist[ i ].GetVoltage();
    Tbool notyet = Ttrue;
    for ( Tsize_t j = 0; j < graphvoltage.size(); j ++ ) {    
      if ( graphvoltage[ j ] == v ) {
	notyet = Tfalse;
	break;
      }
    }
    if ( notyet ) {
      graphvoltage.push_back( v );
    }
  }


  TApplication* theApplication = rootinit();
  TCanvas CVdcvsacc( "CVdcvsacc", "DC VS Acc. Time", 600, 800 );
  //gStyle -> SetOptStat( 0000000 );
  //gStyle -> SetOptFit( 0000 );
  //CVdcvsacc.SetGridx( kFALSE );

  TGraphErrors* ge = new TGraphErrors[ graphvoltage.size() ];
  Tint ngraph = (Tint)graphvoltage.size();
  for ( Tint gid = 0; gid < ngraph; gid ++ ) {
    Tstring title = "voltage" + dtostr( graphvoltage[ gid ] );
    ge[ gid ].SetName( title.c_str() );
    ge[ gid ].SetMarkerColor( gid + 2 );
    ge[ gid ].SetLineColor( gid + 2 );
    Tint pid = 0;
    for ( Tsize_t i = 0; i < datasetlist.size(); i ++ ) {
      if ( graphvoltage[ gid ] == datasetlist[ i ].GetVoltage() ) {
	Tdouble x = datasetlist[ i ].GetCycle();
	Tdouble xe = 0.0;
	Tdouble y = datasetlist[ i ].GetAverage();
	Tdouble ye = datasetlist[ i ].GetRms() / sqrt( datasetlist[ i ].GetNumberOfData() );
	ge[ gid ].SetPoint( pid, x, y );
	ge[ gid ].SetPointError( pid, xe, ye );
	pid ++;
      }
    }
  }


  Tdouble ymin, ymax;
  Tstring ans;
  while ( ans != "y" ) {
    Tcout << "Ymin? ";
    Tcin >> ymin;
    Tcout << "Ymax? ";
    Tcin >> ymax;

    CVdcvsacc.cd();
    CVdcvsacc.Clear();

    gPad -> DrawFrame( 0.0, ymin, 10.0, ymax );
    for ( Tint gid = 0; gid < ngraph; gid ++ ) {
      if ( gid == 0 ) {
	ge[ gid ].GetXaxis() -> SetTitle( "Accumulation Time (sec)" );
	ge[ gid ].GetYaxis() -> SetTitle( "Average Electron (e^{-}/pixel)" );
      }
      ge[ gid ].Draw( "p" );
    }

    CVdcvsacc.Modified();
    CVdcvsacc.Update();

    gSystem -> ProcessEvents();
    Tcout << "OK? [n/y] ";
    Tcin >> ans;
  }


  TLegend leg( 0.7, 0.6, 0.9, 0.9 );
  leg.SetName( "leg" );
  for ( Tint gid = 0; gid < ngraph; gid ++ ) {
    Tstring text = dtostr( graphvoltage[ gid ] );
    text += "V";
    leg.AddEntry( &ge[ gid ], text.c_str(), "p" );
  }
  CVdcvsacc.cd();
  leg.Draw();
  CVdcvsacc.Modified();
  CVdcvsacc.Update();





  TCanvas CVvshift( "CVvshift", "DC VS Voltage of Vertical Register" );
  TGraphErrors result;
  //TGraph result;
  result.SetName( "result" );
  //result.SetMarkerStyle( 0 ); // only error bar
  for ( Tint gid = 0; gid < ngraph; gid ++ ) {
    ge[ gid ].Fit( "pol1", "qm0" );
    TF1* f = ge[ gid ].GetFunction( "pol1" );
    result.SetPoint( gid, graphvoltage[ gid ], f -> GetParameter( 1 ) );
    result.SetPointError( gid, 0.0, f -> GetParError( 1 ) );
  }

  CVvshift.cd();
  CVvshift.SetGridx( kFALSE );
  CVvshift.SetLogy();
  //gPad -> DrawFrame( 0.1, 0.1, 12.0, 3000.0 );
  result.Draw( "ap" );
  result.GetXaxis() -> SetTitle( "Negative Drive Pulse Voltage of Vertical Register (V)" );
  result.GetYaxis() -> SetTitle( "Dark Current (e^{-}/pixel/sec)" );
  CVvshift.Modified();
  CVvshift.Update();





  theApplication -> Run();
  delete [] ge;

  return( 0 );
}
