// =====================================================================
//  $Id: St01BadChannelMap.hh,v 1.1 2003/06/27 19:16:42 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __ST01BADCHANNELMAP_HH
#define __ST01BADCHANNELMAP_HH

#include "Tglobals.h"
#include "St01Map.hh"
#include "St01OfflineDarkRmsMap.hh"

class St01BadChannelMap
  : public St01Map
{

  private:
    St01OfflineDarkRmsMap theOfflineDarkRmsMap;

  public:
    St01BadChannelMap( const Tstring& filename );
    ~St01BadChannelMap();

  public:
    const St01OfflineDarkRmsMap& GetOfflineDarkRmsMap() const;

  public:
    Tbool IsBadChannel( Tint row, Tint col ) const;
    Tbool IsGoodChannel( Tint row, Tint col ) const;
    Tvoid SetBadChannel( Tint row, Tint col );
    Tvoid SetGoodChannel( Tint row, Tint col );
    Tint GetNumberOfBadChannels() const;
    Tint GetNumberOfGoodChannels() const;

};

inline const St01OfflineDarkRmsMap& St01BadChannelMap::GetOfflineDarkRmsMap() const
{
  return( theOfflineDarkRmsMap );
}

#endif
