// =====================================================================
//  $Id: St01OfflineDarkAverageMap.hh,v 1.1 2003/06/27 19:16:43 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __ST01OFFLINEDARKAVERAGEMAP_HH
#define __ST01OFFLINEDARKAVERAGEMAP_HH

#include "Tglobals.h"
#include "St01Map.hh"

class St01OfflineDarkAverageMap
  : public St01Map
{

  private:
    TDataMultiplicity theCounterMap;
    Tint theNumberOfFrames;

  public:
    St01OfflineDarkAverageMap( const Tstring& filename );
    ~St01OfflineDarkAverageMap();

  public:
    Tvoid FillMap( Tshort* data, Tint ndata );
    const TDataMultiplicity& GetCounterMap() const;
    TDataMultiplicity& GetCounterMap();
    Tint GetNumberOfFrames() const;

};

inline const TDataMultiplicity& St01OfflineDarkAverageMap::GetCounterMap() const
{
  return( theCounterMap );
}

inline TDataMultiplicity& St01OfflineDarkAverageMap::GetCounterMap()
{
  return( theCounterMap );
}

inline Tint St01OfflineDarkAverageMap::GetNumberOfFrames() const
{
  return( theNumberOfFrames );
}

#endif
