// =====================================================================
//  $Id: TAnalysisSuspendCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TAnalysisSuspendCommand.hh"
#include "TRunManager.hh"
#include "TAnalysisManager.hh"

static const Tstring _name = "/analysis/suspend";
static const Tstring _desc = "suspend an analysis.";

TAnalysisSuspendCommand::TAnalysisSuspendCommand( TRunManager* runman, TAnalysisManager* anaman )
  : TCommand( runman, _name, _desc ), TAnalysisCommand( anaman )
{;}

TAnalysisSuspendCommand::~TAnalysisSuspendCommand()
{;}

Tvoid TAnalysisSuspendCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    theAnalysisManager -> SuspendAnalysis();
  } else {
    for ( Tsize_t i = 0; i < arguments.size(); i ++ )
      theAnalysisManager -> SuspendAnalysis( arguments[ i ] );
  }
  return;
}
