// =====================================================================
//  $Id: TRunEventLimitCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#include "TRunEventLimitCommand.hh"
#include "TRunManager.hh"

static const Tstring _name = "/run/eventlimit";
static const Tstring _desc = "set number of events taken in this run.\nif you want to cancel this limit, set to 0 or less.\nexample> /run/eventlimit 100";

TRunEventLimitCommand::TRunEventLimitCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TRunEventLimitCommand::~TRunEventLimitCommand()
{;}

Tvoid TRunEventLimitCommand::Execute( const TstringList& arguments )
{
  if ( arguments.empty() ) {
    Tcout << theRunManager -> GetEventLimit() << Tendl;
  } else if ( arguments.size() == 1 ) {
    Tint nevents = strtol( arguments[ 0 ].c_str(), 0, 0 );
    theRunManager -> SetEventLimit( nevents );
  } else {
    ShowCommandDetail();
  }

  return;
}
