// =====================================================================
//  $Id: TCrateDefinition.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TCRATEDEFINITION_HH
#define __TCRATEDEFINITION_HH

#include "Tglobals.h"

class TCrate;
class TRunManager;

class TCrateDefinition
{

  protected:
    TRunManager* theRunManager;

  public:
    TCrateDefinition( TRunManager* manager = 0 );
    virtual ~TCrateDefinition();

  public:
    virtual TCrate* Define() = 0;

  public:
    TRunManager* GetRunManager() const;
    Tvoid SetRunManager( TRunManager* manager );

};

inline TRunManager* TCrateDefinition::GetRunManager() const
{
  return( theRunManager );
}

inline Tvoid TCrateDefinition::SetRunManager( TRunManager* manager )
{
  theRunManager = manager;
  return;
}

#endif
