// =====================================================================
//  $Id: TReadoutSegment.hh,v 1.2 2003/07/05 23:53:49 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TREADOUTSEGMENT_HH
#define __TREADOUTSEGMENT_HH

#include "Tglobals.h"
#include "TReadoutIdentification.hh"
#include "TReadoutElementList.hh"

class TModule;
class TDataSegment;

class TReadoutSegment
  : public TReadoutIdentification, public TReadoutElementList
{

  private:
    TModule* theModule;

  public:
    TReadoutSegment( const Tstring& id = TunknownID );
    TReadoutSegment( TModule* module, const Tstring& id = TunknownID );
    TReadoutSegment( TModule* module, Tint ch, const Tstring& id = TunknownID );
    TReadoutSegment( TModule* module, const TstringList& elementid, const Tstring& id = TunknownID );
    TReadoutSegment( TModule* module, const Tstring elementid[], const Tstring& id = TunknownID );
    TReadoutSegment( const TReadoutSegment& right );
    ~TReadoutSegment();

  public:
    const TReadoutSegment& operator=( const TReadoutSegment& right );
    Tbool operator==( const TReadoutSegment& right ) const;
    Tbool operator!=( const TReadoutSegment& right ) const;

  public:
    TDataSegment Read();

  public:
    TModule* GetModule() const;
    Tvoid SetModule( TModule* module );

};

inline TModule* TReadoutSegment::GetModule() const
{
  return( theModule );
}

inline Tvoid TReadoutSegment::SetModule( TModule* module )
{
  theModule = module;
  return;
}

#endif
