// =====================================================================
//  $Id: TDataDeflation.hh,v 1.1.1.1 2003/06/27 02:56:42 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TDATADEFLATION_HH
#define __TDATADEFLATION_HH
#ifdef __CLDAQ_ZLIB_USE

#include "Tglobals.h"

// Z_NO_COMPRESSION         0
// Z_BEST_SPEED             1
// Z_BEST_COMPRESSION       9
// Z_DEFAULT_COMPRESSION  (-1)

class TDataDeflation
{

  private:
    enum { tDefaultBufferSize = 1024 * 1024 };

  private:
    Tzstream theDeflationStream;
    Tint theCompressionLevel;
    Tint theStatus;
    Tbyte* theOutputBuffer;
    Tint theSizeOfOutputBuffer;
    Tvoid* theDeflatedData;
    Tint theSizeOfDeflatedData;

  public:
    TDataDeflation( Tint bufsize = tDefaultBufferSize, Tint level = Z_DEFAULT_COMPRESSION );
    TDataDeflation( const TDataDeflation& right );
    ~TDataDeflation();

  public:
    const TDataDeflation& operator=( const TDataDeflation& right );

  public:
    Tvoid Compress( Tvoid* input, Tint nbyte, Tbool islast = Tfalse );

  public:
    const Tzstream& GetDeflationStream() const;
    Tzstream& GetDeflationStream();
    Tint GetCompressionLevel() const;
    Tint GetStatus() const;
    Tint GetSizeOfOutputBuffer() const;
    Tvoid* GetDeflatedData() const;
    Tint GetSizeOfDeflatedData() const;
    Tvoid SetCompressionLevel( Tint level );
    Tvoid SetOutputBuffer( Tint bufsize );

};

inline const Tzstream& TDataDeflation::GetDeflationStream() const
{
  return( theDeflationStream );
}

inline Tzstream& TDataDeflation::GetDeflationStream()
{
  return( theDeflationStream );
}

inline Tint TDataDeflation::GetCompressionLevel() const
{
  return( theCompressionLevel );
}

inline Tint TDataDeflation::GetStatus() const
{
  return( theStatus );
}

inline Tint TDataDeflation::GetSizeOfOutputBuffer() const
{
  return( theSizeOfOutputBuffer );
}

inline Tvoid* TDataDeflation::GetDeflatedData() const
{
  return( theDeflatedData );
}

inline Tint TDataDeflation::GetSizeOfDeflatedData() const
{
  return( theSizeOfDeflatedData );
}

#endif
#endif
