// =====================================================================
//  $Id: TSignalHandler.hh,v 1.1.1.1 2003/06/27 02:56:42 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TSIGNALHANDLER_HH
#define __TSIGNALHANDLER_HH

#include "Tglobals.h"

class TSignalClient;

class TSignalHandler
{

  public:
    enum { MAX_SIGNAL_ENTRY = 32 };

  protected:
    static TSignalHandler* handler_list[ MAX_SIGNAL_ENTRY ];

  protected:
    Tint signal_id;
    TSignalClient* client;

  protected:
    Tvoid signal_ucr( Tint sig );

  public:
    TSignalHandler( Tint psignalid, TSignalClient* pclient );

  public:
    Tvoid Enable();
    Tvoid Disable();
    Tint Wait();

  public:
    static Tvoid Initialize();

  protected:
    static Tvoid signal_handler( Tint, Tint, struct sigcontext* , Tchar* );

};

#endif
