// =====================================================================
//  $Id: Tglobals.h,v 1.1.1.1 2003/06/27 02:56:42 goiwai Exp $
//  $Name: CLDAQ-1-06-00 $
// =====================================================================
#ifndef __TGLOBALS_H
#define __TGLOBALS_H

#include <pthread.h>

#include <X11/Xlib.h>
#include <X11/Xutil.h>
#include <X11/Xatom.h>
#include <X11/cursorfont.h>
#include <X11/keysym.h>
#include <X11/xpm.h>

#include <stdio.h>
#include <string.h>
#include <fstream>
#include <stdlib.h>
#include <time.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <sys/un.h>
#include <fcntl.h>
#include <sys/time.h>
#include <sys/times.h>
#include <errno.h>
#include <math.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <netdb.h>
#include <signal.h>
#include <sys/ioctl.h>
#include <sys/ipc.h>
#include <sys/sem.h>
#include <sys/shm.h>
#include <sys/wait.h>
#include <termios.h>
#include <sys/mman.h>
#include <term.h>
#include <ncurses.h>
#include <unistd.h>
#include <limits.h>
#include <values.h>

#ifdef __CLDAQ_ZLIB_USE
#include <zlib.h>
#endif

#include <linux/param.h>

#ifndef __USE_BSD
typedef __caddr_t caddr_t;
#endif

#if defined(__GNU_LIBRARY__) && !defined(_SEM_SEMUN_UNDEFINED)
// see <sys/sem.h>
#else
// if defer to X/OPEN design
union semun {
  int val;                    // value for SETVAL
  struct semid_ds* buf;       // buffer for IPC_STAT, IPC_SET
  unsigned short int* array;  // array for GETALL, SETALL
  struct seminfo* __buf;      // buffer for IPC_INFO
};
#endif

#include "Ttypes.h"

extern Tchar** environ;

static const Tint _digits = 6;
static const Tsize_t _buflen = 64;
static const Tsize_t _precision = 6;

inline static Tstring itostr( Tint i, Tint digits = _digits )
{
  static const Tsize_t buflen = _buflen;
  static Tchar buf[ buflen ];
  Tostrstream os( buf, buflen );

  if ( i >= 0 ) {
    os << setfill( '0' ) << setiosflags( Tios::right ) << setw( digits );
    os << i << Tends;
    Tstring s = os.str();
    return( s );
  } else {
    os << i << Tends;
    Tstring s = os.str();
    Tint nzero = digits - s.size();
    if ( nzero > 0 ) {
      s.insert( 1, nzero, '0' );
    }
    return( s );
  }
}

inline static Tstring ltostr( Tlong l, Tint digits = _digits )
{
  static const Tsize_t buflen = _buflen;
  static Tchar buf[ buflen ];
  Tostrstream os( buf, buflen );

  if ( l >= 0 ) {
    os << setfill( '0' ) << setiosflags( Tios::right ) << setw( digits );
    os << l << Tends;
    Tstring s = os.str();
    return( s );
  } else {
    os << l << Tends;
    Tstring s = os.str();
    Tint nzero = digits - s.size();
    if ( nzero > 0 ) {
      s.insert( 1, nzero, '0' );
    }
    return( s );
  }
}

inline static Tstring ultostr( TUlong ul, Tint digits = _digits )
{
  static const Tsize_t buflen = _buflen;
  static Tchar buf[ buflen ];
  Tostrstream os( buf, buflen );

  if ( ul >= 0 ) {
    os << setfill( '0' ) << setiosflags( Tios::right ) << setw( digits );
    os << ul << Tends;
    Tstring s = os.str();
    return( s );
  } else {
    os << ul << Tends;
    Tstring s = os.str();
    Tint nzero = digits - s.size();
    if ( nzero > 0 ) {
      s.insert( 1, nzero, '0' );
    }
    return( s );
  }
}

inline static Tstring dtostr( Tdouble d, Tint precision = _precision )
{
  static const Tsize_t buflen = _buflen;
  static Tchar buf[ buflen ];
  Tostrstream os( buf, buflen );

  os << setprecision( precision ) << d << Tends;
  Tstring s = os.str();
  return( s );
}

inline static Tstring ftostr( Tfloat f, Tint precision = _precision )
{
  return( dtostr( (Tdouble)f, precision ) );
}

inline static Tbool isexist( const Tstring& filename )
{
  if ( access( filename.c_str(), F_OK ) == 0 ) {
    return( Ttrue );
  } else {
    return( Tfalse );
  }
}

inline static Tvoid showbit( Tint bit )
{
  Tint nbit = Tsizeof( bit ) * 8;
  for ( Tint i = nbit; i > 0; i -- ) {
    Tcout << ( ( bit >> i - 1 ) & 0x01 );
  }
  Tcout << Tendl;
  return;
}

#endif
