// =====================================================================
//  $Id: Sw00RunAction.hh,v 1.2 2003/06/27 10:04:55 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __SW00RUNACTION_HH
#define __SW00RUNACTION_HH

#include "TRunAction.hh"
#include "TOutputHtmlFileStream.hh"
#include "Sw00RunSummary.hh"

class TRun;
class TOutputObjectFile;
class TDataRecord;

class Sw00RunAction
  : public TRunAction
{

  private:
    TOutputObjectFile* theOutputFile;
    TOutputHtmlFileStream theOutputHtml;
    Sw00RunSummary theRunSummary;

  public:
    Sw00RunAction();
    ~Sw00RunAction();

  public:
    Tvoid BeginOfRunAction( TRun& aRun );
    Tvoid EndOfRunAction( TRun& aRun );

  public:
    TOutputObjectFile* GetOutputFile() const;
    TOutputHtmlFileStream& GetOutputHtml();
    const Sw00RunSummary& GetRunSummary() const;

  private:
    Tvoid fillRunBeginInformation( const TDataRecord& record );
    Tvoid fillRunEndInformation( const TDataRecord& record );
    Tvoid fillHtmlFile();

};

inline TOutputObjectFile* Sw00RunAction::GetOutputFile() const
{
  return( theOutputFile );
}

inline TOutputHtmlFileStream& Sw00RunAction::GetOutputHtml()
{
  return( theOutputHtml );
}

inline const Sw00RunSummary& Sw00RunAction::GetRunSummary() const
{
  return( theRunSummary );
}

#endif
