// =====================================================================
//  $Id: St00RunSummary.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __ST0001RUNSUMMARY_HH
#define __ST0001RUNSUMMARY_HH

#include "TRunInformationTable.hh"
#include "TChannel.hh"

class St00RunSummary
{

  private:
    Tint theRunID;
    Tstring theRecordName;
    Tint theRecordSize;
    Tint theNumberOfEvents;
    TRunInformationTable theRunInformationTable;
    Tstring theRunBeginTime;
    Tstring theRunEndTime;

  public:
    St00RunSummary();
    ~St00RunSummary();

  public:
    TRunInformationTable GenerateRunSummaryTable() const;
    Tvoid Initialize();

  public:
    Tint GetRunID() const;
    const Tstring& GetRecordName() const;
    Tint GetRecordSize() const;
    Tint GetNumberOfEvents() const;
    const TRunInformationTable& GetRunInformationTable() const;
    const Tstring& GetRunBeginTime() const;
    const Tstring& GetRunEndTime() const;
    Tvoid SetRunID( Tint runid );
    Tvoid SetRecordName( const Tstring& recname );
    Tvoid SetRecordSize( Tint size );
    Tvoid SetNumberOfEvents( Tint nevents );
    Tvoid SetRunInformationTable( const TRunInformationTable& table );
    Tvoid SetRunBeginTime( const Tstring& time );
    Tvoid SetRunEndTime( const Tstring& time );

};

inline Tint St00RunSummary::GetRunID() const
{
  return( theRunID );
}

inline const Tstring& St00RunSummary::GetRecordName() const
{
  return( theRecordName );
}

inline Tint St00RunSummary::GetRecordSize() const
{
  return( theRecordSize );
}

inline Tint St00RunSummary::GetNumberOfEvents() const
{
  return( theNumberOfEvents );
}

inline const TRunInformationTable& St00RunSummary::GetRunInformationTable() const
{
  return( theRunInformationTable );
}

inline const Tstring& St00RunSummary::GetRunBeginTime() const
{
  return( theRunBeginTime );
}

inline const Tstring& St00RunSummary::GetRunEndTime() const
{
  return( theRunEndTime );
}

inline Tvoid St00RunSummary::SetRunID( Tint runid )
{
  theRunID = runid;
  return;
}

inline Tvoid St00RunSummary::SetRecordName( const Tstring& recname )
{
  theRecordName = recname;
  return;
}

inline Tvoid St00RunSummary::SetRecordSize( Tint size )
{
  theRecordSize = size;
  return;
}

inline Tvoid St00RunSummary::SetNumberOfEvents( Tint nevents )
{
  theNumberOfEvents = nevents;
  return;
}

inline Tvoid St00RunSummary::SetRunInformationTable( const TRunInformationTable& table )
{
  theRunInformationTable = table;
  return;
}

inline Tvoid St00RunSummary::SetRunBeginTime( const Tstring& time )
{
  theRunBeginTime = time;
  return;
}

inline Tvoid St00RunSummary::SetRunEndTime( const Tstring& time )
{
  theRunEndTime = time;
  return;
}

#endif
