// =====================================================================
//  $Id: TCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TCommand.hh"
#include "TRunManager.hh"

TCommand::TCommand( TRunManager* manager, const Tstring& name, const Tstring& guidance )
  : theRunManager( manager ), theCommandName( name ), theGuidance( guidance )
{;}
TCommand::TCommand( const Tstring& name, const Tstring& guidance )
  : theRunManager( 0 ), theCommandName( name ), theGuidance( guidance )
{;}

TCommand::~TCommand()
{;}

Tvoid TCommand::ShowCommandDetail() const
{
  Tcout << "[" << theCommandName << "]" << Tendl;
  Tcout << theGuidance << Tendl;
  return;
}

Tvoid TCommand::Execute( const TstringList& arguments )
{
  Tcout << theCommandName << " is not implemented." << Tendl;
  return;
}
