// =====================================================================
//  $Id: TCommandSpecified.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TCOMMANDSPECIFIED_HH
#define __TCOMMANDSPECIFIED_HH

#include "Tglobals.h"

class TCommand;


class TCommandSpecified
{
  public:
    enum { 
      tBuiltinDepth = -1, 
      tAliasDepth = -2, 
      tNotDefineDepth = 0x8fffffff
    };

  private:
    Tstring theName;
    Tstring theFullName;
    Tstring theAbsolutePath;
    Tint theDirectoryDepth;
    Tbool theBuiltinFlag;
    TCommand* theCommand;

  public:
    TCommandSpecified();
    TCommandSpecified( const Tstring& name, const Tstring& fullname, const Tstring& path, Tint depth, Tbool flag, TCommand* command );
    TCommandSpecified( const TCommandSpecified& right );
    ~TCommandSpecified();

  public:
    const TCommandSpecified& operator=( const TCommandSpecified& right );
    Tbool operator==( const TCommandSpecified& right ) const;
    Tbool operator!=( const TCommandSpecified& right ) const;

  public:
    friend Tostream& operator<<( Tostream& tos, const TCommandSpecified& right );

  public:
    const Tstring& GetName() const;
    const Tstring& GetFullName() const;
    const Tstring& GetAbsolutePath() const;
    Tint GetDirectoryDepth() const;
    Tbool IsBuiltinCommand() const;
    Tbool IsAliasedCommand() const;
    TCommand* GetCommand() const;
    Tvoid SetName( const Tstring& name );
    Tvoid SetFullName( const Tstring& name );
    Tvoid SetAbsolutePath( const Tstring& path );
    Tvoid SetDirectoryDepth( Tint depth );
    Tvoid SetBuiltinFlag( Tbool flag );
    Tvoid SetCommand( TCommand* command );

};

inline const Tstring& TCommandSpecified::GetName() const
{
  return( theName );
}

inline const Tstring& TCommandSpecified::GetFullName() const
{
  return( theFullName );
}

inline const Tstring& TCommandSpecified::GetAbsolutePath() const
{
  return( theAbsolutePath );
}

inline Tint TCommandSpecified::GetDirectoryDepth() const
{
  return( theDirectoryDepth );
}

inline Tbool TCommandSpecified::IsBuiltinCommand() const
{
  return( theBuiltinFlag );
}

inline Tbool TCommandSpecified::IsAliasedCommand() const
{
  return( theDirectoryDepth == tAliasDepth );
}

inline TCommand* TCommandSpecified::GetCommand() const
{
  return( theCommand );
}

inline Tvoid TCommandSpecified::SetName( const Tstring& name )
{
  theName = name;
  return;
}

inline Tvoid TCommandSpecified::SetFullName( const Tstring& name )
{
  theFullName = name;
  return;
}

inline Tvoid TCommandSpecified::SetAbsolutePath( const Tstring& path )
{
  theAbsolutePath = path;
  return;
}

inline Tvoid TCommandSpecified::SetDirectoryDepth( Tint depth )
{
  theDirectoryDepth = depth;
  return;
}

inline Tvoid TCommandSpecified::SetBuiltinFlag( Tbool flag )
{
  theBuiltinFlag = flag;
  return;
}

inline Tvoid TCommandSpecified::SetCommand( TCommand* command )
{
  theCommand = command;
  return;
}

#endif
