// =====================================================================
//  $Id: TRunStartCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TRunStartCommand.hh"
#include "TRunManager.hh"

static const Tstring _name = "/run/start";
static const Tstring _desc = "start a run.\nif you give a argument, set to run identification.\nhowever, it is omittable.\nexample> /run/start\nexample> /run/start 12345";

TRunStartCommand::TRunStartCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TRunStartCommand::~TRunStartCommand()
{;}

Tvoid TRunStartCommand::Execute( const TstringList& arguments )
{
  if ( !( arguments.empty() ) ) {
    if ( arguments.size() == 1 ) {
      Tstring runid = arguments[ 0 ];
      theRunManager -> StartRun( strtol( runid.c_str(), 0, 0 ) );
      return;
    } else {
      ShowCommandDetail();
      return;
    }
  }

  theRunManager -> StartRun();

  return;
}
