// =====================================================================
//  $Id: TSetRunInformationModuleCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TSetRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"
#include "TUserInterface.hh"

static const Tstring _name = "/run/setinfo";
static const Tstring _desc = "set run information into the table.";

TSetRunInformationModuleCommand::TSetRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, _name, _desc ), TRunInformationModuleCommand( module )
{;}

TSetRunInformationModuleCommand::~TSetRunInformationModuleCommand()
{;}

Tvoid TSetRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  if ( theRunInformationModule == 0 ) {
    return;
  }

  TRunInformationTable& table =
    theRunInformationModule -> GetRunInformationTable();

  if ( arguments.empty() ) {
    table.SetRunInformation();
  } else if ( arguments.size() == 1 ) {
    table.SetRunInformation( arguments[ 0 ] );
  } else if ( arguments.size() == 2 ) {
    table.SetRunInformation( arguments[ 0 ], arguments[ 1 ] );
  } else {
    ShowCommandDetail();
  }
  return;
}
