// =====================================================================
//  $Id: TSetStackSizeCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TSetStackSizeCommand.hh"
#include "TRunManager.hh"
#include "TEventManager.hh"

static const Tstring _name = "/event/stacksize";
static const Tstring _desc = "set stack size.\nexample> /event/stacksize\nexample> /event/stacksize 1234";

TSetStackSizeCommand::TSetStackSizeCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TSetStackSizeCommand::~TSetStackSizeCommand()
{;}

Tvoid TSetStackSizeCommand::Execute( const TstringList& arguments )
{
  TEventManager* manager = theRunManager -> GetEventManager();

  if ( arguments.empty() ) {
    Tcout << manager -> GetStackSize() << Tendl;
  } else {
    if ( arguments.size() == 1 ) {
      Tstring stacksize = arguments[ 0 ];
      manager -> SetStackSize( strtol( stacksize.c_str(), 0, 0 ) );
      return;
    } else {
      ShowCommandDetail();
      return;
    }
  }

  return;
}
