// =====================================================================
//  $Id: TUnaliasCommand.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TUnaliasCommand.hh"
#include "TRunManager.hh"
#include "TUserInterface.hh"
#include "TCommandSpecified.hh"

static const Tstring _name = "unalias";
static const Tstring _desc = "removes all aliases whose names match pattern.\n`unalias *' thus removes all aliases.";

TUnaliasCommand::TUnaliasCommand( TRunManager* manager )
  : TCommand( manager, _name, _desc )
{;}

TUnaliasCommand::~TUnaliasCommand()
{;}

Tvoid TUnaliasCommand::Execute( const TstringList& arguments )
{
  if ( arguments.size() != 1 ) {
    ShowCommandDetail();
    return;
  }

  TUserInterface* ui = theRunManager -> GetUserInterface();

  if ( ui ) {
    TCommandTable& table = ui -> GetCommandTable();
    if ( arguments[ 0 ] == "*" ) {
      for ( Tint i = 0; i < table.GetSize(); i ++ ) {
	if ( table[ i ].IsAliasedCommand() ) {
	  table.RemoveCommand( i );
	}
      }
    } else {
      Tstring abspath = ui -> ModifyPath( arguments[ 0 ] );
      for ( Tint i = 0; i < table.GetSize(); i ++ ) {
	if ( table[ i ].IsAliasedCommand() && table[ i ].GetFullName() == abspath ) {
	  table.RemoveCommand( i );
	  return;
	}
      }
    }
  }
  return;
}
