// =====================================================================
//  $Id: TDataRecord.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TDATARECORD_HH
#define __TDATARECORD_HH

#include "Tglobals.h"
#include "TStreamableObject.hh"
#include "TDataSectionList.hh"

class TOutputObjectStream;

class TDataRecord
  : public TStreamableObject, public TDataSectionList
{

  public:
    TDataRecord( const Tstring& id = TunknownID );
    TDataRecord( const TDataRecord& right );
    ~TDataRecord();

  public:
    Tint GetRecordSize();
    Tint Record( TOutputObjectStream* output );
    Tvoid Clear();
    Tint Serialize( Tvoid* buffer );

  public:
    const TDataRecord& operator=( const TDataRecord& right );
    Tbool operator==( const TDataRecord& right ) const;
    Tbool operator!=( const TDataRecord& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TDataRecord& right );

  public:
    Tbool FindDataSection( const Tstring& id, TDataSection& section ) const;
    Tint FindDataSection( const Tstring& id ) const;
    Tbool FindDataSegment( const Tstring& secid, const Tstring& segid, TDataSegment& segment ) const;
    Tint FindDataSegment( const Tstring& secid, const Tstring& segid ) const;
    Tbool FindDataSegment( Tstring idset[ 2 ], TDataSegment& segment ) const;
    Tint FindDataSegment( Tstring idset[ 2 ] ) const;
    Tbool FindDataSegment( const TstringList& idset, TDataSegment& segment ) const;
    Tint FindDataSegment( const TstringList& idset ) const;
    Tbool FindDataElement( const Tstring& secid, const Tstring& segid, const Tstring& eleid, TDataElement& element ) const;
    Tint FindDataElement( const Tstring& secid, const Tstring& segid, const Tstring& eleid ) const;
    Tbool FindDataElement( Tstring idset[ 3 ], TDataElement& element ) const;
    Tint FindDataElement( Tstring idset[ 3 ] ) const;
    Tbool FindDataElement( const TstringList& idset, TDataElement& element ) const;
    Tint FindDataElement( const TstringList& idset ) const;

  private:
    Tint record( TOutputObjectFile* ofile );
    Tint record( TOutputObjectSocket* osocket );
    Tint record( TOutputObjectSharedMemory* omemory );

};

#endif
