// =====================================================================
//  $Id: TDataSection.hh,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TDATASECTION_HH
#define __TDATASECTION_HH

#include "Tglobals.h"
#include "TStreamableObject.hh"
#include "TDataSegmentList.hh"

class TOutputObjectStream;
class TOutputObjectFile;
class TOutputObjectSocket;
class TOutputObjectSharedMemory;

class TDataSection
  : public TStreamableObject, public TDataSegmentList
{

  public:
    TDataSection( const Tstring& id = TunknownID );
    TDataSection( const TDataSection& right );  
    ~TDataSection();

  public:
    Tint GetRecordSize();
    Tint Record( TOutputObjectStream* objectfile );
    Tvoid Clear();
    Tint Serialize( Tvoid* buffer );

  public:
    const TDataSection& operator=( const TDataSection& right );
    Tbool operator==( const TDataSection& right ) const;
    Tbool operator!=( const TDataSection& right ) const;
    friend Tostream& operator<<( Tostream& tos, const TDataSection& right );

  public:
    Tbool FindDataSegment( const Tstring& id, TDataSegment& segment ) const;
    Tint FindDataSegment( const Tstring& id ) const;
    Tbool FindDataElement( const Tstring& segid, const Tstring& eleid, TDataElement& element ) const;
    Tint FindDataElement( const Tstring& segid, const Tstring& eleid ) const;
    Tbool FindDataElement( Tstring idset[ 2 ], TDataElement& element ) const;
    Tint FindDataElement( Tstring idset[ 2 ] ) const;
    Tbool FindDataElement( const TstringList& idset, TDataElement& element ) const;
    Tint FindDataElement( const TstringList& idset ) const;

  private:
    Tint record( TOutputObjectFile* ofile );
    Tint record( TOutputObjectSocket* osocket );
    Tint record( TOutputObjectSharedMemory* omemory );

};

#endif
