// =====================================================================
//  $Id: TEvent.cc,v 1.1.1.1 2003/06/27 02:56:41 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TEvent.hh"

TEvent::TEvent( Tint eventID )
  : theEventID( eventID ), theDataRecord()
{;}

TEvent::TEvent( const TDataRecord& eventData )
  : theEventID( 0 ), theDataRecord( eventData )
{;}

TEvent::TEvent( Tint eventID, const TDataRecord& eventData )
  : theEventID( eventID ), theDataRecord( eventData )
{;}

TEvent::TEvent( const TEvent& right )
  : theEventID( right.theEventID ), 
    theDataRecord( right.theDataRecord )
{;}

TEvent::~TEvent()
{;}

const TEvent& TEvent::operator=( const TEvent& right )
{
  theEventID = right.theEventID;
  theDataRecord = right.theDataRecord;
  return( *this );
}

Tbool TEvent::operator==( const TEvent& right ) const
{
  if ( theEventID == right.theEventID && theDataRecord == right.theDataRecord ) {
    return( Ttrue );
  } else {
    return( Tfalse );
  }
}

Tbool TEvent::operator!=( const TEvent& right ) const
{
  if ( theEventID != right.theEventID || theDataRecord != right.theDataRecord ) {
    return( Ttrue );
  } else {
    return( Tfalse );
  }
}

Tvoid TEvent::Clear()
{
  theDataRecord.Clear();
  theEventID = 0;
  return;
}

Tstring TEvent::GetStringEventID( Tint digits ) const
{
  return( itostr( theEventID, digits ) );
}
