// =====================================================================
//  $Id: TTerminalUserInterface.hh,v 1.1.1.1 2003/06/27 02:56:42 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TTERMINALUSERINTERFACE_HH
#define __TTERMINALUSERINTERFACE_HH

#include "Tglobals.h"
#include "TUserInterface.hh"

class TTerminalUserInterface
  : public TUserInterface
{

  private:
    Tint theCommandHistoryIndex;
    Tint theCursorPosition;
    Tstring thePrompt;
    Tstring theAcceptString;
    Tstring theStringBuffer;
    Tstring theCommandBuffer;
    struct termios theTerminal;

  public:
    TTerminalUserInterface( const Tstring& prompt = Tprompt, const Tstring& history = Tproject + ".last" );
    ~TTerminalUserInterface();

  public:
    Tbool AcceptCommand();
    const Tstring& GetInputCommand();
    Tvoid NotFoundCommand( const Tstring& commandname ) const;

  public:
    Tint GetCommandHistoryIndex() const;
    Tint GetCursorPosition() const;
    const Tstring& GetPrompt() const;
    const Tstring& GetAcceptString() const;
    const Tstring& GetStringBuffer() const;
    const Tstring& GetCommandBuffer() const;
    Tvoid SetCursorPosition( Tint position );
    Tvoid SetPrompt( const Tstring& prompt );
    Tvoid SetAcceptString( const Tstring& accept );
    Tvoid SetStringBuffer( const Tstring& buffer );
    Tvoid SetCommandBuffer( const Tstring& buffer );
    Tvoid SetCommandHistoryIndex( Tint index );

  protected:
    const Tstring& readLine();
    Tvoid initializeCommandLine();
    Tvoid insertCharacter( Tchar cc );
    Tvoid backspaceCharacter();
    Tvoid deleteCharacter();
    Tvoid clearLine();
    Tvoid clearScreen();
    Tvoid clearAfterCursor();
    Tvoid forwardCursor();
    Tvoid backwardCursor();
    Tvoid moveCursorTop();
    Tvoid moveCursorEnd();
    Tvoid nextCommand();
    Tvoid previousCommand();
    Tvoid completeCommand();
    Tvoid complete();
    Tvoid complete( const Tstring& input );
    Tvoid complete( const TstringList& inputs );
    Tvoid completeDirectory();
    Tvoid completeDirectory( const Tstring& input );
    Tvoid cutCharacter();
    Tvoid pasteCharacter();
    Tvoid suspendTerminal() const;
    Tvoid setTerminalInputMode();
    Tvoid resetTerminal();
    Tbool isCursorEnd() const;
    Tbool isCursorTop() const;
    TstringList divide( const Tstring& input ) const;

};

inline Tint TTerminalUserInterface::GetCommandHistoryIndex() const
{
  return( theCommandHistoryIndex );
}

inline Tvoid TTerminalUserInterface::SetCommandHistoryIndex( Tint index )
{
  theCommandHistoryIndex = index;
  return;
}

inline Tint TTerminalUserInterface::GetCursorPosition() const
{
  return( theCursorPosition );
}

inline const Tstring& TTerminalUserInterface::GetPrompt() const
{
  return( thePrompt );
}

inline const Tstring& TTerminalUserInterface::GetAcceptString() const
{
  return( theAcceptString );
}

inline const Tstring& TTerminalUserInterface::GetStringBuffer() const
{
  return( theStringBuffer );
}

inline const Tstring& TTerminalUserInterface::GetCommandBuffer() const
{
  return( theCommandBuffer );
}

inline Tvoid TTerminalUserInterface::SetCursorPosition( Tint position )
{
  theCursorPosition = position;
  return;
}

inline Tvoid TTerminalUserInterface::SetPrompt( const Tstring& prompt )
{
  thePrompt = prompt;
  return;
}

inline Tvoid TTerminalUserInterface::SetAcceptString( const Tstring& accept )
{
  theAcceptString = accept;
  return;
}

inline Tvoid TTerminalUserInterface::SetStringBuffer( const Tstring& buffer )
{
  theStringBuffer = buffer;
  return;
}

inline Tvoid TTerminalUserInterface::SetCommandBuffer( const Tstring& buffer )
{
  theCommandBuffer = buffer;
  return;
}

inline Tbool TTerminalUserInterface::isCursorEnd() const
{
  return( ( theCursorPosition == (Tint)( theAcceptString.size() ) ) ? Ttrue : Tfalse );
}

inline Tbool TTerminalUserInterface::isCursorTop() const
{
  return( ( theCursorPosition == 0 ) ? Ttrue : Tfalse );
}

#endif
