// =====================================================================
//  $Id: TRs232cKeithley2400Module.hh,v 1.1 2003/06/27 10:02:03 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TRS232CKEITHLEY2400MODULE_HH
#define __TRS232CKEITHLEY2400MODULE_HH

#include "Tglobals.h"
#include "TRs232cModule.hh"

class TRs232cKeithley2400Module
  : public TRs232cModule
{

  public:
    TRs232cKeithley2400Module( const Tstring devfile = "/dev/ttyS0", Tint nchannel = 1 );
    TRs232cKeithley2400Module( Tint nchannel, Tstring devfile = "/dev/ttyS0" );
    TRs232cKeithley2400Module( const TRs232cKeithley2400Module& right );
    ~TRs232cKeithley2400Module();

  protected:
    Tvoid defineClearMethod( Tint channel );
    Tvoid defineUpdateMethod( Tint channel ) ;
    Tvoid defineInitializeMethod( Tint channel );
    Tvoid defineReadMethod( Tint channel );
    Tbool modifyData( const Tstring& accept, Tdouble& databuf ) const;

};

#endif
