// =====================================================================
//  $Id: TReadoutBook.hh,v 1.1.1.1 2003/06/27 02:56:42 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TREADOUTBOOK_HH
#define __TREADOUTBOOK_HH

#include "Tglobals.h"
#include "TReadoutIndex.hh"

class TReadoutList;
class TDataRecord;

class TReadoutBook
{

  private:
    TReadoutIndex theReadoutIndex;

  public:
    TReadoutBook();
    ~TReadoutBook();

  public:
    const TReadoutIndex& GetReadoutIndex() const;
    TReadoutIndex& GetReadoutIndex();
    Tvoid SetReadoutIndex( const TReadoutIndex& index );

  public:
    Tint AddReadoutList( TReadoutList* readoutlist );
    Tint RemoveReadoutList( Tint index );
    Tint RemoveReadoutList( const Tstring& id );
    Tvoid ClearReadoutBook();
    TReadoutList* FindReadoutList( const Tstring& id );
    TReadoutList* GetReadoutList( Tint index );
    TReadoutList* GetReadoutList( const Tstring& id );
    TDataRecord Read( const Tstring& id );

};

inline const TReadoutIndex& TReadoutBook::GetReadoutIndex() const
{
  return( theReadoutIndex );
}

inline TReadoutIndex& TReadoutBook::GetReadoutIndex()
{
  return( theReadoutIndex );
}

inline Tvoid TReadoutBook::SetReadoutIndex( const TReadoutIndex& index )
{
  theReadoutIndex = index;
  return;
}

#endif
