// =====================================================================
//  $Id: TReadoutBookDefinition.hh,v 1.1.1.1 2003/06/27 02:56:42 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TREADOUTBOOKDEFINITION_HH
#define __TREADOUTBOOKDEFINITION_HH

#include "Tglobals.h"

class TReadoutBook;
class TCrate;
class TRunManager;

class TReadoutBookDefinition
{

  protected:
    TRunManager* theRunManager;
    TCrate* theCrate;

  public:
    TReadoutBookDefinition( TRunManager* manager = 0 );
    virtual ~TReadoutBookDefinition();

  public:
    virtual TReadoutBook* Define() = 0;

  public:
    TRunManager* GetRunManager() const;
    Tvoid SetRunManager( TRunManager* manager );
    TCrate* GetCrate() const;
    Tvoid SetCrate( TCrate* crate );

};

inline TRunManager* TReadoutBookDefinition::GetRunManager() const
{
  return( theRunManager );
}

inline Tvoid TReadoutBookDefinition::SetRunManager( TRunManager* manager )
{
  theRunManager = manager;
  return;
}

inline TCrate* TReadoutBookDefinition::GetCrate() const
{
  return( theCrate );
}

inline Tvoid TReadoutBookDefinition::SetCrate( TCrate* crate )
{
  theCrate = crate;
  return;
}

#endif
