// =====================================================================
//  $Id: TReadoutIdentification.hh,v 1.1.1.1 2003/06/27 02:56:42 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TREADOUTIDENTIFICATION_HH
#define __TREADOUTIDENTIFICATION_HH

#include "Tglobals.h"

class TReadoutIdentification
{

  protected:
    Tstring theID;

  public:
    TReadoutIdentification( const Tstring& id );
    TReadoutIdentification( const TReadoutIdentification& right );

  protected:
    virtual ~TReadoutIdentification();

  public:
    virtual const TReadoutIdentification& operator=( const TReadoutIdentification& right );
    virtual Tbool operator==( const TReadoutIdentification& right ) const;
    virtual Tbool operator!=( const TReadoutIdentification& right ) const;

  public:
    const Tstring& GetID() const;
    Tvoid SetID( const Tstring& id );

};

inline const Tstring& TReadoutIdentification::GetID() const
{
  return( theID );
}

inline Tvoid TReadoutIdentification::SetID( const Tstring& id )
{
  theID = id;
  return;
}

#endif
