// =====================================================================
//  $Id: TRunAction.hh,v 1.2 2003/06/27 10:00:36 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TRUNACTION_HH
#define __TRUNACTION_HH

#include "Tglobals.h"

class TRun;
class TRunManager;
class TEventManager;
class TReadoutBook;
class TCrate;

class TRunAction
{

  protected:
    TRunManager* theRunManager;
    TEventManager* theEventManager;
    TReadoutBook* theReadoutBook;
    TCrate* theCrate;

  public:
    TRunAction();
    virtual ~TRunAction();

  public:
    virtual Tvoid BeginOfRunAction( TRun& aRun );
    virtual Tvoid EndOfRunAction( TRun& aRun );

  public:
    TRunManager* GetRunManager() const;
    TEventManager* GetEventManager() const;
    TReadoutBook* GetReadoutBook() const;
    TCrate* GetCrate() const;
    Tvoid SetRunManager( TRunManager* manager );
    Tvoid SetEventManager( TEventManager* manager );
    Tvoid SetReadoutBook( TReadoutBook* book );
    Tvoid SetCrate( TCrate* crate );

};

inline TRunManager* TRunAction::GetRunManager() const
{
  return( theRunManager );
}

inline TEventManager* TRunAction::GetEventManager() const
{
  return( theEventManager );
}

inline TReadoutBook* TRunAction::GetReadoutBook() const
{
  return( theReadoutBook );
}

inline TCrate* TRunAction::GetCrate() const
{
  return( theCrate );
}

inline Tvoid TRunAction::SetRunManager( TRunManager* manager )
{
  theRunManager = manager;
  return;
}

inline Tvoid TRunAction::SetEventManager( TEventManager* manager )
{
  theEventManager = manager;
  return;
}

inline Tvoid TRunAction::SetReadoutBook( TReadoutBook* book )
{
  theReadoutBook = book;
  return;
}

inline Tvoid TRunAction::SetCrate( TCrate* crate )
{
  theCrate = crate;
  return;
}

#endif
