// =====================================================================
//  $Id: TBenchmark.cc,v 1.1.1.1 2003/06/27 02:56:42 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#include "TBenchmark.hh"

TBenchmark::TBenchmark( const Tstring& unit )
  : theSystemTimer( unit ), theSystemClock(), theStartTime(), theStopTime()
{;}

TBenchmark::~TBenchmark()
{;}

Tvoid TBenchmark::Start()
{
  theSystemTimer.Start();
  theStartTime = theSystemClock.WhatTimeIsItNow();
  return;
}

Tvoid TBenchmark::Pause()
{
  theSystemTimer.Pause();
  theSystemTimer.Lap();
  return;
}

Tvoid TBenchmark::Restart()
{
  theSystemTimer.Restart();
  return;
}

Tvoid TBenchmark::Stop()
{
  theSystemTimer.Stop();
  theStopTime = theSystemClock.WhatTimeIsItNow();
  return;
}

Tvoid TBenchmark::Lap()
{
  theSystemTimer.Lap();
  return;
}

Tvoid TBenchmark::Continue()
{
  theSystemTimer.Lap();
  return;
}

Tvoid TBenchmark::PrintResult()
{
  Tcout << *this << Tendl;
  return;
}

Tostream& operator<<( Tostream& tos, const TBenchmark& right )
{
  tos << "Start: " << right.theStartTime << Tendl;
  tos << "Stop: " << right.theStopTime << Tendl;
  tos << right.theSystemTimer << Tflush;
  return( tos );
}
