// =====================================================================
//  $Id: TSystemClock.hh,v 1.1.1.1 2003/06/27 02:56:42 goiwai Exp $
//  $Name: CLDAQ-1-06-02 $
// =====================================================================
#ifndef __TSYSTEMCLOCK_HH
#define __TSYSTEMCLOCK_HH

#include "Tglobals.h"

class TSystemClock
{

  private:
    // elapsed time in second from 1970/1/1/00:00:00
    // ߻ʹ,ɬ theLastRequiredTime = theTime 줬Update()
    // ǤդλҤͤƤ⤳ϵʤ
    Tint theAllocatedTime;
    Tint theLastUpdateTime;
    Tint theTime;

  public:
    TSystemClock();
    TSystemClock( const TSystemClock& right );
    ~TSystemClock();

  public:
    const TSystemClock& operator=( const TSystemClock& right );
    friend Tostream& operator<<( Tostream& tos, const TSystemClock& right );

  public:
    Tstring WhatTimeIsItNow();
    Tstring WhatTimeIsIt( Tint second = -1 );
    Tstring WhenAllocated();
    Tstring WhenUpdate();
    Tint GetElapsedTime( const Tstring& unit = Tsec );
    Tint GetElapsedTimeOfLastUpdate( const Tstring& unit = Tsec );
    Tint GetYear( Tint second = -1 );
    Tint GetMonth( Tint second = -1 );
    Tint GetDay( Tint second = -1 );
    Tint GetHour( Tint second = -1 );
    Tint GetMinute( Tint second = -1 );
    Tint GetSecond( Tint second = -1 );
    Tint Update();

  public:
    Tint GetAllocatedTime() const;
    Tint GetLastUpdateTime() const;
    Tint GetTime() const;

};

inline Tint TSystemClock::GetAllocatedTime() const
{
  return( theAllocatedTime );
}

inline Tint TSystemClock::GetLastUpdateTime() const
{
  return( theLastUpdateTime );
}

inline Tint TSystemClock::GetTime() const
{
  return( theTime );
}

#endif
