// =====================================================================
//  $Id: rs01view.cc,v 1.8 2003/07/30 16:14:41 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: rs01view.cc,v $
//  Revision 1.8  2003/07/30 16:14:41  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TEnvironmentVariableTable.hh"
#include "TInputObjectFile.hh"
#include "Trootinit.h"

static const Tstring rcpath = "rs01setup";
static const Tint npin = 32;
static Tint pinpos[ npin ] = {
           3,  4, 5,   6,  7,
      10, 11, 12, 13, 14, 15, 16,
  17, 18, 19, 20, 21, 22, 23, 24,
      26, 27, 28, 29, 30, 31, 32,
          35, 36, 37, 38, 39
};

TInputObjectFile* ifile = 0;
TEnvironmentVariableTable* envtable = 0;
TDataRecord record;
TDataElement element;
Tdouble vdc[ npin ];
Tint elapsed[ npin ];
Tdouble integrated[ npin ];
Tdouble pedestal[ npin ];

Tstring lastupdate[ npin ];
//
TApplication* theApplication = 0;
TCanvas* CVpro = 0;
TCanvas* CVvdc = 0;
static const Tint nx = 8;
static const Tint ny = 5;

TH2D* H2Dpro = 0;
TH2D* H2Dint = 0;
TPaveText* PTinfo;

Tofstream runlog;
Tstring fpath, macrof, giff, psf, rootf;
static Tbool autoprint, enableoverwrite;
static Tint modperiod;

static Tvoid initialize( Tint argc, Tchar** argv );
static Tvoid event();
static Tvoid runbegin();
static Tvoid runend();
static Tvoid sizezero();

int main( int argc, char** argv, char** envv )
{
  initialize( argc, argv );

  while ( 1 ) {
    Tint datasize = ifile -> Read( record );
    if ( datasize == 0 ) {
      sizezero();
      continue;
    }

    Tstring recid = record.GetID();
    if ( recid == "RUN BEGIN" ) {
      runbegin();
      continue;
    } else if ( recid == "EVENT" ) {
      event();
    } else if ( recid == "RUN END" ) {
      runend();
      break;
    } else {
      Tcerr << "unknown tag: " << recid << Tendl;
      break;
    }
    gSystem -> ProcessEvents();
  }

  theApplication -> Run();
  return( 0 );
}

Tvoid initialize( Tint argc, Tchar** argv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <run#>" << Tendl;
    exit( -1 );
  }

  Tint runid = (Tint)strtol( argv[ 1 ], 0, 0 );
  Tstring runidstr = itostr( runid );

  Tstring htpro = "Beam Profile Monitor, Run ID: " + runidstr;
  Tstring htint = "Beam Profile Monitor(Integrated), Run ID: " + runidstr;


  envtable = new TEnvironmentVariableTable ( rcpath );
  Tstring rechead = envtable -> GetEnvironmentValue( "RS01_RECORD_HEAD" );
  Tstring recpath = envtable -> GetEnvironmentValue( "RS01_RECORD_DIR" );
  fpath = recpath + Tslash + rechead + runidstr + ".drec";
  Tstring logpath = recpath + Tslash + rechead + runidstr + ".log";
  ifile = new TInputObjectFile( fpath );
  runlog.open( logpath.c_str() );


  Tstring rootdir = envtable -> GetEnvironmentValue( "RS01_ROOTFILE_DIR" );
  rootf = rootdir + Tslash + rechead + runidstr + "pm.root";
  Tstring macrodir = envtable -> GetEnvironmentValue( "RS01_ROOTFILE_DIR" );
  macrof = macrodir + Tslash + rechead + runidstr + "pm.C";
  Tstring gifdir = envtable -> GetEnvironmentValue( "RS01_FIGURE_DIR" );
  giff = gifdir + Tslash + rechead + runidstr + "pm.gif";
  Tstring psdir = envtable -> GetEnvironmentValue( "RS01_FIGURE_DIR" );
  psf = psdir + Tslash + rechead + runidstr + "pm.ps";

  modperiod = envtable -> GetIntegerValue( "RS01_UPDATE_PERIOD" );
  enableoverwrite = (Tbool)envtable -> GetIntegerValue( "RS01_OVERWRITE_ENABLE" );
  autoprint = (Tbool)envtable -> GetIntegerValue( "RS01_AUTO_PRINT" );

  // ڥǥ
  for ( Tint i = 0; i < npin; i ++ ) {
    Tstring item = "RS01_PEDESTAL_" + itostr( i, 2 );
    pedestal[ i ] = envtable -> GetDoubleValue( item );
  }


  theApplication = rootinit();
  TGaxis::SetMaxDigits( 1 );

  // ҥåȤ2D Х
  CVpro = new TCanvas( "CVpro", "Distribution", 960, 720 );
  CVpro -> ToggleEventStatus();
  CVpro -> Divide( 2, 1 );
  CVpro -> GetPad( 1 ) -> Divide( 1, 2 );

  // ҥåʬۤν
  H2Dpro = new TH2D( "H2Dpro", htpro.c_str(), 8, 0.0, 8.0, 5, 0.0, 5.0 );
  H2Dpro -> SetStats(0);
  H2Dpro -> GetXaxis() -> SetTitle( "Horizontal Position" );
  H2Dpro -> GetXaxis() -> SetNoExponent();
  H2Dpro -> GetXaxis() -> CenterTitle();
  H2Dpro -> GetYaxis() -> SetTitle( "Vertical Position" );
  H2Dpro -> GetYaxis() -> SetNoExponent();
  H2Dpro -> GetYaxis() -> CenterTitle();
  H2Dpro -> GetZaxis() -> SetTitle( "DC Voltage (V)");
  H2Dpro -> GetZaxis() -> CenterTitle();
  H2Dpro -> GetZaxis() -> SetNoExponent();
  CVpro -> GetPad( 1 ) -> cd( 1 );
  gPad -> SetLeftMargin( 0.16 );
  gPad -> SetRightMargin( 0.16 );
  gPad -> SetTopMargin( 0.18 );
  gPad -> SetBottomMargin( 0.2 );
  H2Dpro -> Draw( "colz" );

  //
  H2Dint = new TH2D( "H2Dint", htint.c_str(), 8, 0.0, 8.0, 5, 0.0, 5.0 );
  H2Dint -> SetStats(0);
  H2Dint -> GetXaxis() -> SetTitle( "Horizontal Position" );
  H2Dint -> GetXaxis() -> SetNoExponent();
  H2Dint -> GetXaxis() -> CenterTitle();
  H2Dint -> GetYaxis() -> SetTitle( "Vertical Position" );
  H2Dint -> GetYaxis() -> SetNoExponent();
  H2Dint -> GetYaxis() -> CenterTitle();
  H2Dint -> GetZaxis() -> SetTitle( "Integrated Voltage (Vsec)");
  H2Dint -> GetZaxis() -> CenterTitle();
  H2Dint -> GetZaxis() -> SetNoExponent();
  CVpro -> GetPad( 1 ) -> cd( 2 );
  gPad -> SetLeftMargin( 0.16 );
  gPad -> SetRightMargin( 0.16 );
  gPad -> SetTopMargin( 0.18 );
  gPad -> SetBottomMargin( 0.2 );
  H2Dint -> Draw( "colz" );



  // ƥȾν
  PTinfo = new TPaveText( 0.02, 0.02, 0.98, 0.98 );
  PTinfo -> SetFillColor( 10 );
  PTinfo -> SetFillStyle( 0 );
  PTinfo -> SetBorderSize( 0 );
  PTinfo -> SetTextAlign( 12 );
  CVpro -> cd( 2 );
  PTinfo -> Draw();

  return;
}

Tvoid event()
{
  H2Dpro -> Reset();
  H2Dint -> Reset();
  PTinfo -> Clear();
  element = record[ 0 ][ 0 ][ 0 ];
  Tint eventid;
  element.StorePrimitives( &eventid );
  for ( Tint ch = 0; ch < npin; ch ++ ) {
    // VDCΥʥåץå
    element = record[ 1 ][ ch ][ 0 ];
    element.StorePrimitives( &vdc[ ch ] );

    // λ
    element = record[ 1 ][ ch ][ 1 ];
    element.StorePrimitives( &lastupdate[ ch ] );

    // 󳫻Ϥηвÿ(sec)
    element = record[ 1 ][ ch ][ 3 ];
    element.StorePrimitives( &elapsed[ ch ] );

    // ɤߤηвÿ(msec)
    element = record[ 1 ][ ch ][ 4 ];
    Tdouble secbuf;
    element.StorePrimitives( &secbuf );
    secbuf /= 1000.0;

    // VDC * sec (ڥǥΤȤ)
    // ڥǥ Run ID 101  Ȥꤢ٥ID0 Τ
    // run#113ʹߤrun112ΤΤȤ
    integrated[ ch ] += ( vdc[ ch ] - pedestal[ ch ] ) * secbuf;
    // ڥǥϰʤ
    //integrated[ ch ] += vdc[ ch ] * secbuf;


    // ҥåʬۤؤΥե
    Tint x = ( pinpos[ ch ] - 1 ) % nx;
    Tint y = ny - ( ( pinpos[ ch ] - 1 ) / nx ) - 1;
    H2Dpro -> Fill( (Tdouble)x, (Tdouble)y, vdc[ ch ] );
    H2Dint -> Fill( (Tdouble)x, (Tdouble)y, integrated[ ch ] );

    // ƥȥޥ
    Tstring sbuf;
    sbuf = "CH" + itostr( ch, 2 ) + ": " + dtostr( vdc[ ch ] ) + "VDC, ";
    sbuf += itostr( elapsed[ ch ], 0 ) + "sec, ";
    sbuf += dtostr( integrated[ ch ] ) + "Vsec, ";
    sbuf += lastupdate[ ch ];
    PTinfo -> AddText( sbuf.c_str() );

    // 
    runlog << ch << Ttab;
    runlog << vdc[ ch ] << Ttab;
    runlog << elapsed[ ch ] << Ttab;
    runlog << integrated[ ch ] << Ttab;
    runlog << lastupdate[ ch ] << Tendl;
  }


  // update
  if ( eventid % modperiod == 0 ) {
    CVpro -> GetPad(1)->GetPad(1)->Modified();
    CVpro -> GetPad(1)->GetPad(1)->Update();
    CVpro -> GetPad(1)->GetPad(2)->Modified();
    CVpro -> GetPad(1)->GetPad(2)->Update();
    CVpro -> GetPad(2)->Modified();
    CVpro -> GetPad(2)->Update();
  }



  return;
}

Tvoid runbegin()
{
  element = record[ 0 ][ 1 ][ 1 ];
  Tint secbuf;
  element.StorePrimitives( &secbuf );
  gStyle -> SetTimeOffset( secbuf );
  return;
}

Tvoid runend()
{
  // update
  CVpro -> GetPad(1)->GetPad(1)->Modified();
  CVpro -> GetPad(1)->GetPad(1)->Update();
  CVpro -> GetPad(1)->GetPad(2)->Modified();
  CVpro -> GetPad(1)->GetPad(2)->Update();
  CVpro -> GetPad(2)->Modified();
  CVpro -> GetPad(2)->Update();

  // printout
  CVpro -> cd();
  if ( !isexist( rootf ) || enableoverwrite ) {
    CVpro -> Print( rootf.c_str() );
  }
  if ( !isexist( macrof ) || enableoverwrite ) {
    CVpro -> Print( macrof.c_str() );
  }
  if ( !isexist( giff ) || enableoverwrite ) {
    CVpro -> Print( giff.c_str() );
  }
  if ( !isexist( psf ) || enableoverwrite ) {
    CVpro -> Print( psf.c_str() );
    if ( autoprint ) {
      Tstring exec = "lpr " + psf;
      system( exec.c_str() );
    }
  }

  runlog.close();
  return;
}

Tvoid sizezero()
{
  ifile -> SetOffset( ifile -> GetTotalDataSize(), SEEK_SET );
  usleep( 1000*1000 );
  gSystem -> ProcessEvents();
  return;
}
