// =====================================================================
//  $Id: sw00.cc,v 1.2 2003/07/30 16:15:16 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: sw00.cc,v $
//  Revision 1.2  2003/07/30 16:15:16  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRunManager.hh"
#include "TTerminalUserInterface.hh"
#include "TCrate.hh"

#include "Sw00RunAction.hh"
#include "Sw00EventAction.hh"
#include "Sw00CrateDefinition.hh"
#include "Sw00ReadoutBookDefinition.hh"
#include "Sw00AdcViewCommand.hh"
#include "Sw00FlashAdcViewCommand.hh"
#include "Sw00Geant4ViewCommand.hh"

int main( int argc, char** argv, char** envv )
{
  TRunManager* manager = new TRunManager( new TTerminalUserInterface() );

  manager -> GetEnvironmentVariableTable().SetEnvironment( "sw00setup" );
  manager -> SetRunAction( new Sw00RunAction() );
  manager -> SetEventAction( new Sw00EventAction() );
  manager -> SetCrateDefinition( new Sw00CrateDefinition() );
  manager -> SetReadoutBookDefinition( new Sw00ReadoutBookDefinition() );

  manager -> SetUserCommand( new Sw00AdcViewCommand() );
  manager -> SetUserCommand( new Sw00FlashAdcViewCommand() );
  manager -> SetUserCommand( new Sw00Geant4ViewCommand() );


  manager -> SessionStart();

  delete manager;
  return( 0 );
}
