// =====================================================================
//  $Id: St02RunAction.cc,v 1.2 2003/07/30 16:16:34 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: St02RunAction.cc,v $
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TOutputObjectFile.hh"
#include "TRun.hh"
#include "TReadoutList.hh"
#include "TDataRecord.hh"
#include "TDataSection.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"
#include "TReadoutBook.hh"
#include "TCrate.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TSoftwareScalerModule.hh"
#include "TEnvironmentVariableTable.hh"
#include "TVmeRpv130Module.hh"

#include "St02RunAction.hh"
#include "St02RunSummary.hh"

St02RunAction::St02RunAction()
  : theOutputFile( 0 ), theRunSummary( 0 ), theOutputHtml()
{;}

St02RunAction::~St02RunAction()
{;}

Tvoid St02RunAction::BeginOfRunAction( TRun& aRun )
{
  Tstring drecfile;
  Tstring htmlfile;
  setFileName( aRun.GetRunID(), drecfile, htmlfile );

  theOutputFile = new TOutputObjectFile( drecfile );
  Tcout << "event data outputs into " << drecfile << Tendl;

  theCrate -> Initialize( "run begin" );

  TSoftwareScalerModule* runid =
    (TSoftwareScalerModule*)( theCrate -> GetModule( "runid" ) );
  runid -> SetData( 0, aRun.GetRunID() );

  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN BEGIN" ) -> Read();
  theOutputFile -> Write( record );

  theOutputHtml.Open( htmlfile );
  Tcout << "run summary outputs into " << htmlfile << Tendl;
  theRunSummary = new St02RunSummary();
  fillRunBeginInformation( record );

  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tint veto = envtable.GetIntegerValue( "ST02_RPV130_OUT_VETO" );
  Tint stop = envtable.GetIntegerValue( "ST02_RPV130_OUT_STOP" );
  TVmeRpv130Module* rpv130 =
    (TVmeRpv130Module*)( theCrate -> GetModule( "rpv130" ) );

  rpv130 -> Pulse( stop );
  rpv130 -> LevelUp( veto );

  return;
}

Tvoid St02RunAction::EndOfRunAction( TRun& aRun )
{
  TDataRecord record =
    theReadoutBook -> GetReadoutList( "RUN END" ) -> Read();
  theOutputFile -> Write( record );


  fillRunEndInformation( record );
  Tstring title = "Run Summary #" + (theRunManager->GetRun()).GetStringRunID();
  theOutputHtml.SetTitle( title );
  theOutputHtml << theRunSummary -> GenerateRunSummaryTable() << Tendl;
  theOutputHtml.Close();


  Tstring htmlfile = theOutputHtml.GetFileName();
  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();
  Tbool autoprint = (Tbool)envtable.GetIntegerValue( "ST02_AUTO_PRINT" );
  if ( autoprint ) {
    // http://www.tdb.uu.se/~jan/html2ps.html
    Tstring html2ps = envtable.GetEnvironmentValue( "ST02_HTML2PS" );
    Tstring command = html2ps + " " + htmlfile + " | lpr";
    // or convert runXXXXXX.html runXXXXXX.ps; lpr runXXXXXX.ps
    system( command.c_str() );
  }

  delete theRunSummary;
  delete theOutputFile;
  theRunSummary = 0;
  theOutputFile = 0;


  return;
}

Tvoid St02RunAction::setFileName( Tint runid, Tstring& drecfile, Tstring& htmlfile )
{
  static const Tstring drecext = ".drec";
  static const Tstring htmlext = ".html";


  const TEnvironmentVariableTable& envtable = 
    theRunManager -> GetEnvironmentVariableTable();

  Tstring filehead = envtable.GetEnvironmentValue( "ST02_RECORD_HEAD" );
  Tstring drecdir = envtable.GetEnvironmentValue( "ST02_RECORD_DIR" );
  Tstring htmldir = envtable.GetEnvironmentValue( "ST02_SUMMARY_DIR" );
  Tbool overwrite = (Tbool)envtable.GetIntegerValue( "ST02_OVERWRITE_ENABLE" );

  Tstring runidstr = itostr( runid );
  drecfile = drecdir + Tslash + filehead + runidstr + drecext;
  htmlfile = htmldir + Tslash + filehead + runidstr + htmlext;

  if ( overwrite == 0 ) {
    if ( isexist( drecfile ) ) {
      Tcout << "already exist " << drecfile << "." << Tendl;
      drecfile += "." + itostr( theRunManager->GetRunClock().GetLastUpdateTime() );
    }
    if ( isexist( htmlfile ) ) {
      Tcout << "already exist " << htmlfile << "." << Tendl;
      htmlfile += "." + itostr( theRunManager->GetRunClock().GetLastUpdateTime() );
    }
  }

  return;
}

Tvoid St02RunAction::fillRunBeginInformation( const TDataRecord& record )
{
  static Tstring runidset[ 3 ] = { "INFO", "RUN ID", "0" };
  static Tstring clockset[ 3 ] = { "INFO", "CLOCK", "0" };
  TDataElement runid;
  TDataElement clock;
  Tint intbuf;
  Tstring strbuf;
  record.FindDataElement( runidset, runid );
  record.FindDataElement( clockset, clock );
  runid.StorePrimitives( &intbuf );
  clock.StorePrimitives( &strbuf );

  theRunSummary -> SetRecordName( theOutputFile -> GetFileName() );
  theRunSummary -> SetRunID( intbuf );
  theRunSummary -> SetRunBeginTime( strbuf );

  return;
}

Tvoid St02RunAction::fillRunEndInformation( const TDataRecord& record )
{
  static Tstring clockset[ 3 ] = { "INFO", "CLOCK", "0" };
  TDataElement clock;
  Tstring strbuf;
  record.FindDataElement( clockset, clock );
  clock.StorePrimitives( &strbuf );

  const TRunInformationTable& table = 
    theRunManager -> GetRunInformationModule() -> GetRunInformationTable();


  theRunSummary -> SetRunInformationTable( table );
  theRunSummary -> SetRunEndTime( strbuf );
  theRunSummary -> SetRecordSize( theOutputFile -> GetTotalDataSize() );

  return;
}
