// =====================================================================
//  $Id: TCamacCrateController.cc,v 1.2 2003/07/30 16:19:09 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: TCamacCrateController.cc,v $
//  Revision 1.2  2003/07/30 16:19:09  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TCamacCrateController.hh"

TCamacCrateController::TCamacCrateController()
  : TModule( 0 ), theCrateControllerType( tCamacCrateControllerUnknown ), 
    theCrateID( -1 ), theFileDescriptor( -1 ), theISA7000( Tfalse )
{
  theStatus = tStatusSuccess;
}

TCamacCrateController::TCamacCrateController( TcamacCrateController_t cctype )
  : TModule( 0 ), theCrateControllerType( cctype ), 
    theCrateID( -1 ), theFileDescriptor( -1 ),
    theISA7000( Tfalse )
{
  const Tstring head = "TCamacCrateController::TCamacCrateController";
  
  // open device file
  if ( !IsOpen() )
    Open();
  if ( theFileDescriptor < 0 ) {
    perror( head.c_str() );
    exit( theStatus );
  }

  // check the power
  if ( !IsOnline() ) {
    perror( head.c_str() );
    exit( theStatus );
  }

  theISA7000 |= ( theCrateControllerType == tISAcc7000_1 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_2 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_3 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_4 );

  theStatus = tStatusSuccess;
}

TCamacCrateController::TCamacCrateController( const TCamacCrateController& right )
  : TModule( right ),
    theCrateControllerType( right.theCrateControllerType ), 
    theCrateID( -1 ), theFileDescriptor( -1 ),
    theISA7000( Tfalse )
{
  const Tstring head = "TCamacCrateController::TCamacCrateController";
  
  // open device file
  if ( !IsOpen() )
    Open();
  if ( theFileDescriptor < 0 ) {
    perror( head.c_str() );
    exit( theStatus );
  }

  // check the power
  if ( !IsOnline() ) {
    perror( head.c_str() );
    exit( theStatus );
  }

  theISA7000 |= ( theCrateControllerType == tISAcc7000_1 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_2 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_3 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_4 );

  theStatus = tStatusSuccess;
}

const TCamacCrateController& TCamacCrateController::operator=( const TCamacCrateController& right )
{
  const Tstring head = "TCamacCrateController::operator=";

  *( (TModule*)this ) = *( (TModule*)(&right) );

  theCrateControllerType = right.theCrateControllerType;
  theCrateID = -1;
  theFileDescriptor = -1;
  theStatus = -1;
  theISA7000 = Tfalse;

  // open device file
  if ( !IsOpen() )
    Open();
  if ( theFileDescriptor < 0 ) {
    perror( head.c_str() );
    exit( theStatus );
  }

  // check the power
  if ( !IsOnline() ) {
    perror( head.c_str() );
    exit( theStatus );
  }

  theISA7000 |= ( theCrateControllerType == tISAcc7000_1 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_2 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_3 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_4 );

  theStatus = tStatusSuccess;
  return( *this );
}

Tbool TCamacCrateController::operator==( const TCamacCrateController& right ) const
{
  Tbool ret = Ttrue;
  ret &= ( *( (TModule*)this ) == *( (TModule*)(&right) ) );
  ret &= ( theCrateControllerType == right.theCrateControllerType );
  ret &= ( theCrateID == right.theCrateID );
  ret &= ( theISA7000 == right.theISA7000 );
  return( ret );
}

Tbool TCamacCrateController::operator!=( const TCamacCrateController& right ) const
{
  Tbool ret = Tfalse;
  ret |= ( *( (TModule*)this ) != *( (TModule*)(&right) ) );
  ret |= ( theCrateControllerType != right.theCrateControllerType );
  ret |= ( theCrateID != right.theCrateID );
  ret |= ( theISA7000 != right.theISA7000 );
  return( ret );
}

TCamacCrateController::~TCamacCrateController()
{
  if ( IsOpen() )
    Close();
}

Tvoid TCamacCrateController::Open()
{
  errno ^= errno;
  theFileDescriptor =
    open( ( TcamacDevices[ theCrateControllerType ] ).c_str(), O_RDWR );
  theStatus = -errno;
  return;
}

Tvoid TCamacCrateController::Close()
{
  errno ^= errno;
  close( theFileDescriptor );
  theFileDescriptor = -1;
  theStatus = -errno;
  return;
}

Tbool TCamacCrateController::IsOpen()
{
  if ( theFileDescriptor < 0 )
    return( Tfalse );
  return( Ttrue );
}

Tbool TCamacCrateController::IsOnline()
{
  errno ^= errno;
  Tint retval = ioctl( theFileDescriptor, IOC_TEST_ONLINE );
  theStatus = -errno;
  if ( retval < 0 )
    return( Tfalse );
  return( Ttrue );
}

Tint TCamacCrateController::Reset()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_RESET_CRATE );
  return( theStatus = -errno );
}

Tint TCamacCrateController::Initialize()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_SET_Z );
  return( theStatus = -errno );
}

Tint TCamacCrateController::Clear()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_SET_C );
  return( theStatus = -errno );
}

Tint TCamacCrateController::Update()
{
  return( Clear() );
}

Tvoid TCamacCrateController::FillData( TDataElement& element, Tint channel )
{
  // nothing to do.
  return;
}

Tint TCamacCrateController::SetInhibition()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_SET_I );
  return( theStatus = -errno );
}

Tint TCamacCrateController::ReleaseInhibition()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_RESET_I );
  return( theStatus = -errno );
}

Tint TCamacCrateController::EnableInterrupt()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_SET_EI );
  return( theStatus = -errno );
}

Tint TCamacCrateController::DisableInterrupt()
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_RESET_EI );
  return( theStatus = -errno );
}

Tvoid TCamacCrateController::SetCrateID( Tint crateid )
{
  errno ^= errno;
  ioctl( theFileDescriptor, IOC_SET_CN, crateid );
  theStatus = -errno;
  return;
}

Tvoid TCamacCrateController::SetCrateControllerType( TcamacCrateController_t type )
{
  theCrateControllerType = type;
  theISA7000 = Tfalse;
  theISA7000 |= ( theCrateControllerType == tISAcc7000_1 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_2 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_3 );
  theISA7000 |= ( theCrateControllerType == tISAcc7000_4 );
  return;
}
