// =====================================================================
//  $Id: TInputObjectStream.hh,v 1.2 2003/07/30 16:19:30 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: TInputObjectStream.hh,v $
//  Revision 1.2  2003/07/30 16:19:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TINPUTOBJECTSTREAM_HH
#define __TINPUTOBJECTSTREAM_HH

#include "Tglobals.h"
#include "TObjectStream.hh"

class TStreamableObject;
class TObjectFilter;

class TInputObjectStream
  : public TObjectStream
{

  public:
    TInputObjectStream( Tstream_t streamtype = tUnknownStream );
    TInputObjectStream( TObjectFilter* filter, Tstream_t streamtype = tUnknownStream );

  protected:
    virtual ~TInputObjectStream();

  public:
    virtual Tint Read( TStreamableObject& object ) = 0;
    friend Tint operator>>( TInputObjectStream& left, TStreamableObject& object );
    friend Tint operator>>( TInputObjectStream& left, const TStreamableObject& object );

};

inline Tint operator>>( TInputObjectStream& left, TStreamableObject& object )
{
  return( left.Read( object ) );
}

inline Tint operator>>( TInputObjectStream& left, const TStreamableObject& object )
{
  return( left.Read( *(TStreamableObject*)(&object) ) );
}

#endif
