// =====================================================================
//  $Id: TRun.cc,v 1.2 2003/07/30 16:20:30 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: TRun.cc,v $
//  Revision 1.2  2003/07/30 16:20:30  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRun.hh"
#include "TEventManager.hh"

TRun::TRun( Tint runid )
  : theRunID( runid ), theEventStack()
{
  theEventStack.clear();
}

TRun::TRun( const TEventStack& eventstack )
  : theRunID( 0 ), theEventStack( eventstack )
{;}

TRun::TRun( Tint runid, const TEventStack& eventstack )
  : theRunID( runid ), theEventStack( eventstack )
{;}

TRun::TRun( const TRun& right )
  : theRunID( right.theRunID ), theEventStack( right.theEventStack )
{;}

TRun::~TRun()
{;}

const TRun& TRun::operator=( const TRun& right )
{
  theRunID = right.theRunID;
  theEventStack = right.theEventStack;
  return( *this );
}

Tbool TRun::operator==( const TRun& right ) const
{
  if ( theRunID == right.theRunID && theEventStack == right.theEventStack )
    return( Ttrue );
  else
    return( Tfalse );
}

Tbool TRun::operator!=( const TRun& right ) const
{
  if ( theRunID != right.theRunID || theEventStack != right.theEventStack )
    return( Ttrue );
  else
    return( Tfalse );
}

Tvoid TRun::Clear()
{
  theEventStack.clear();
  TEventManager::GetEventManager() -> SetNumberOfEvents( 0 );
  return;
}

Tstring TRun::GetStringRunID( Tint digits ) const
{
  return( itostr( theRunID, digits ) );
}
