// =====================================================================
//  $Id: TMacroFileParser.hh,v 1.2 2003/07/30 16:21:21 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: TMacroFileParser.hh,v $
//  Revision 1.2  2003/07/30 16:21:21  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TMACROFILEPARSER_HH
#define __TMACROFILEPARSER_HH

#include "Tglobals.h"

class TMacroFileParser
{

  private:
    Tstring theMacroFileName;
    TstringList theCommentStringList;
    Tifstream theMacroFileStream;

  public:
    TMacroFileParser();
    TMacroFileParser( const Tstring& input );
    TMacroFileParser( const Tstring& input, const TstringList& comment );
    TMacroFileParser( const TMacroFileParser& right );
    ~TMacroFileParser();

  public:
    Tvoid Open();
    Tvoid Open( const Tstring& filename );
    Tbool IsOpen();
    Tbool IsGood() const;
    Tbool IsFail() const;
    Tbool IsEndOfFile() const;
    Tbool IsSuccess();
    Tvoid Close();
    TstringList ReadLine();
    Tbool IsExecutable( const TstringList& readbuf ) const;
    Tstring GetCommand( const TstringList& readbuf ) const;
    TstringList GetArguments( const TstringList& readbuf ) const;

  public:
    const Tstring& GetMacroFileName() const;
    Tvoid SetMacroFileName( const Tstring& filename );
    const TstringList& GetCommentStringList() const;
    TstringList GetCommentStringList();
    Tvoid SetCommentStringList( const TstringList& list );
    Tifstream& GetMacroFileStream();

  private:
    Tvoid checkFileStream();
    TstringList divideLine( Tstring& readline ) const;
    const Tstring& eraseComment( Tstring& readline ) const;

};

inline const Tstring& TMacroFileParser::GetMacroFileName() const
{
  return( theMacroFileName );
}

inline Tvoid TMacroFileParser::SetMacroFileName( const Tstring& filename )
{
  theMacroFileName = filename;
  return;
}

inline const TstringList& TMacroFileParser::GetCommentStringList() const
{
  return( theCommentStringList );
}

inline TstringList TMacroFileParser::GetCommentStringList()
{
  return( theCommentStringList );
}

inline Tvoid TMacroFileParser::SetCommentStringList( const TstringList& list )
{
  theCommentStringList = list;
  return;
}

inline Tifstream& TMacroFileParser::GetMacroFileStream()
{
  return( theMacroFileStream );
}


#endif
