// =====================================================================
//  $Id: ofile.cc,v 1.2 2003/07/30 16:21:39 goiwai Exp $
//  $Name: CLDAQ-1-07-00 $
//
//  $Log: ofile.cc,v $
//  Revision 1.2  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TOutputObjectFile.hh"
#include "TBenchmark.hh"

#include "testrecord.h"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <nevent>" << Tendl;
    return( -1 );
  }
  const Tint nevent = atoi( argv[ 1 ] );
  const Tstring filename = "ofile.drec";
  TOutputObjectFile ofile( filename );
  Tint datasize = 0;
  Tint nevents = 0;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    TDataRecord record = testrecord( i );
    ofile << record;
    datasize += record.GetRecordSize();
    nevents ++;
  }
  bench.Stop();
  Tcout << bench << Tendl;

  Tcout << nevents << " events, ";
  Tcout << datasize << Tslash << ofile.GetTotalDataSize();
  Tcout << " byte data has been written down " << filename << "." << Tendl;

  return( 0 );
}
