// =====================================================================
//  $Id: Bt00RunSummary.hh,v 1.2 2003/07/30 16:13:49 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: Bt00RunSummary.hh,v $
//  Revision 1.2  2003/07/30 16:13:49  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __BT00RUNSUMMARY_HH
#define __BT00RUNSUMMARY_HH

#include "TRunInformationTable.hh"
#include "TChannel.hh"

class Bt00RunSummary
{

  private:
    Tint theRunID;
    Tstring theRecordName;
    Tint theRecordSize;
    Tint theNumberOfCsIEvents;
    Tint theNumberOfScalerEvents;
    Tint theNumberOfAllEvents;
    TRunInformationTable theRunInformationTable;
    TChannel theAccumulatedScaler;
    Tstring theRunBeginTime;
    Tstring theRunEndTime;

  public:
    Bt00RunSummary();
    ~Bt00RunSummary();

  public:
    TRunInformationTable GenerateRunSummaryTable() const;
    Tvoid Initialize();

  public:
    Tint GetRunID() const;
    const Tstring& GetRecordName() const;
    Tint GetRecordSize() const;
    Tint GetNumberOfCsIEvents() const;
    Tint GetNumberOfScalerEvents() const;
    Tint GetNumberOfAllEvents() const;
    const TRunInformationTable& GetRunInformationTable() const;
    Tvoid AddAccumulatedScaler( Tint ch, Tint ncounts );
    Tvoid SetAccumulatedScaler( const TChannel& sclaer );
    const TChannel& GetAccumulatedScaler() const;
    const Tstring& GetRunBeginTime() const;
    const Tstring& GetRunEndTime() const;
    Tvoid SetRunID( Tint runid );
    Tvoid SetRecordName( const Tstring& recname );
    Tvoid SetRecordSize( Tint size );
    Tvoid SetNumberOfCsIEvents( Tint nevents );
    Tvoid SetNumberOfScalerEvents( Tint nevents );
    Tvoid SetNumberOfAllEvents( Tint nevents );
    Tvoid SetRunInformationTable( const TRunInformationTable& table );
    Tvoid SetRunBeginTime( const Tstring& time );
    Tvoid SetRunEndTime( const Tstring& time );

};

inline Tint Bt00RunSummary::GetRunID() const
{
  return( theRunID );
}

inline const Tstring& Bt00RunSummary::GetRecordName() const
{
  return( theRecordName );
}

inline Tint Bt00RunSummary::GetRecordSize() const
{
  return( theRecordSize );
}

inline Tint Bt00RunSummary::GetNumberOfCsIEvents() const
{
  return( theNumberOfCsIEvents );
}

inline Tint Bt00RunSummary::GetNumberOfScalerEvents() const
{
  return( theNumberOfScalerEvents );
}

inline Tint Bt00RunSummary::GetNumberOfAllEvents() const
{
  return( theNumberOfAllEvents );
}

inline const TRunInformationTable& Bt00RunSummary::GetRunInformationTable() const
{
  return( theRunInformationTable );
}

inline const Tstring& Bt00RunSummary::GetRunBeginTime() const
{
  return( theRunBeginTime );
}

inline const Tstring& Bt00RunSummary::GetRunEndTime() const
{
  return( theRunEndTime );
}

inline Tvoid Bt00RunSummary::SetRunID( Tint runid )
{
  theRunID = runid;
  return;
}

inline Tvoid Bt00RunSummary::SetRecordName( const Tstring& recname )
{
  theRecordName = recname;
  return;
}

inline Tvoid Bt00RunSummary::SetRecordSize( Tint size )
{
  theRecordSize = size;
  return;
}

inline Tvoid Bt00RunSummary::SetNumberOfCsIEvents( Tint nevents )
{
  theNumberOfCsIEvents = nevents;
  return;
}

inline Tvoid Bt00RunSummary::SetNumberOfScalerEvents( Tint nevents )
{
  theNumberOfScalerEvents = nevents;
  return;
}

inline Tvoid Bt00RunSummary::SetNumberOfAllEvents( Tint nevents )
{
  theNumberOfAllEvents = nevents;
  return;
}

inline Tvoid Bt00RunSummary::SetRunInformationTable( const TRunInformationTable& table )
{
  theRunInformationTable = table;
  return;
}

inline Tvoid Bt00RunSummary::SetRunBeginTime( const Tstring& time )
{
  theRunBeginTime = time;
  return;
}

inline Tvoid Bt00RunSummary::SetRunEndTime( const Tstring& time )
{
  theRunEndTime = time;
  return;
}

inline Tvoid Bt00RunSummary::SetAccumulatedScaler( const TChannel& scaler )
{
  theAccumulatedScaler = scaler;
  return;
}

inline const TChannel& Bt00RunSummary::GetAccumulatedScaler() const
{
  return( theAccumulatedScaler );
}

inline Tvoid Bt00RunSummary::AddAccumulatedScaler( Tint ch, Tint ncounts )
{
  theAccumulatedScaler[ ch ] += ncounts;
  return;
}

#endif
