// =====================================================================
//  $Id: OFFctiwg.cc,v 1.1 2003/08/05 20:26:30 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: OFFctiwg.cc,v $
//  Revision 1.1  2003/08/05 20:26:30  goiwai
//  OFFctiwgäޤ.
//  󥰥ԥ륤٥ȥǡCTIݤWǥեåƥ
//  󥰤,CTI򻻽ФץǤ.ͤ㤯(6sigmaȤ)ԡ
//  դĤǤƤޤͭǤ.
//  ͤ⤯(20sigmaȤ)ԡҤȤĤξOFFctiǤǤ.
//
// =====================================================================
#include "TEnvironmentVariableTable.hh"
#include "Trootinit.h"
#include "St02SinglePixelInterface.hh"

Tbool goodfit( Tdouble par[], Tdouble pare[] );
static const Tdouble lowfitxmin = 0.0;
static const Tdouble lowfitxmax = 120.0;
static const Tdouble highfitxmin = 300.0;
static const Tdouble highfitxmax = 500.0;

int main( int argc, char** argv, char** envv )
{
  Tbool isprint = Tfalse;
  if ( argc != 2 && argc != 3 ) {
    Tcerr << "usage: " << argv[ 0 ] << " <dataset> [1|0]" << Tendl;
    return( -1 );
  }
  if ( argc == 3 ) {
    isprint = (Tbool)strtol( argv[ 2 ], 0, 0 );
  }

  TApplication* theApplication = rootinit();

  TCanvas CVcti( "CVcti", "CTI", 960, 720 );
  CVcti.ToggleEventStatus();
  CVcti.Divide( 2, 2 );
  TH1D H1Dspx( "H1Dspx", "Single Pixel Events", 100, 0.0, 500.0 );
  TGaxis::SetMaxDigits( 2 );
  H1Dspx.GetXaxis()->SetTitle("Pulseheight (ADU)");
  H1Dspx.GetXaxis()->CenterTitle();
  H1Dspx.GetXaxis()->SetNoExponent();
  H1Dspx.GetYaxis()->SetTitle("Counts");
  H1Dspx.GetYaxis()->CenterTitle();




  Tstring dataset = argv[ 1 ];
  St02SinglePixelInterface spif( dataset );
  St02SinglePixelList splist = spif.GetSinglePixelList();

  TEnvironmentVariableTable envtable( "st02setup" );
  //Tdouble left = envtable.GetDoubleValue( "ST02_MANUALCUT_LEFT" );
  //Tdouble right = envtable.GetDoubleValue( "ST02_MANUALCUT_RIGHT" );
  // ʬΥѥ᡼
  const Tint hdivide = envtable.GetIntegerValue( "ST02_CTI_HDIVIDE" );
  const Tint vdivide = envtable.GetIntegerValue( "ST02_CTI_VDIVIDE" );

  // HCTI,VCTIΥץåȲ뤫
  Tint nptHCTI = 0;
  Tint nptVCTI = 0;

  Tint nh = envtable.GetIntegerValue( "ST02_HPIXEL" );
  Tint nv = envtable.GetIntegerValue( "ST02_VPIXEL" );
  Tint hpitch = nh / vdivide;
  Tint vpitch = nv / hdivide;


  for ( Tsize_t i = 0; i < splist.size(); i ++ ) {
    H1Dspx.Fill( splist[ i ].GetSignal() );
  }


  //check
  CVcti.cd( 1 );

  Tdouble par[ 6 ];
  TF1* g1 = new TF1("g1","gaus",lowfitxmin,lowfitxmax);  // 㤤ۤΥեå
  TF1* g2 = new TF1("g2","gaus",highfitxmin,highfitxmax);// ⤤ۤΥեå


  //ʬեåȤƥѥ᡼
  H1Dspx.Fit(g1,"q0r");
  H1Dspx.Fit(g2,"q0r+");
  g1->GetParameters(&par[0]);
  g2->GetParameters(&par[3]);

  //ΤΥեå
  TF1* total = new TF1("total","gaus(0)+gaus(3)",lowfitxmin,highfitxmax);
  total->SetParameters( par );
  total->SetLineWidth( 1 );
  H1Dspx.Fit(total,"q");

  CVcti.Update();
  ((TPaveStats*)(H1Dspx.FindObject( "stats" )))->SetY1NDC(0.2);





  //==================================================================
  //                                          ___________
  // ˥ե졼ʬ䤷HCTI    |  |  |  |  |
  //                                         |  |  |  |  |
  //                                         |  |  |  |  |
  //                                         |  |  |  |  |
  //                                         |__|__|__|__|
  //
  //==================================================================
  //ΰʬΥҥȤäɽ
  TH1D** H1Dvdivide = new TH1D*[ vdivide ];
  for ( Tint i = 0; i < vdivide; i ++ ) {
    Tstring title = "Vertical Partition(for HCTI): " + itostr( i, 0 );
    Tstring name = "H1Dvdivide" + itostr( i, 3 );

    H1Dvdivide[ i ] = new TH1D( name.c_str(), title.c_str(), 100, 0.0, 500.0 );

    H1Dvdivide[ i ] -> GetXaxis()->SetTitle("Pulseheight (ADU)");
    H1Dvdivide[ i ] -> GetXaxis()->CenterTitle();
    H1Dvdivide[ i ] -> GetXaxis()->SetNoExponent();
    H1Dvdivide[ i ] -> GetYaxis()->SetTitle("Counts");
    H1Dvdivide[ i ] -> GetYaxis()->CenterTitle();
  }
  for ( Tsize_t i = 0; i < splist.size(); i ++ ) {
    Tint h = splist[ i ].GetHorizontalID() ;
    Tdouble s = splist[ i ].GetSignal();
    H1Dvdivide[ h/hpitch ] -> Fill( s );
  }

  TCanvas CVvdivide( "CVvdivide", "Divide Vertical Direction for HCTI", 960, 720 );
  CVvdivide.ToggleEventStatus();
  CVvdivide.Divide( 4, 4 );

  Tdouble* nHt = new Tdouble[ vdivide ];       // ʿžβ
  Tdouble* nHt_e = new Tdouble[ vdivide ];     // ʿžΥ顼
  Tdouble* adcV = new Tdouble[ vdivide ];      // ĤڤäϰϤǤADC濴
  Tdouble* adcV_e = new Tdouble[ vdivide ];    // ADCΥ顼
  for ( Tint i = 0; i < vdivide; i ++ ) {
    CVvdivide.cd( i + 1 );

    Tdouble par[ 6 ];
    // 㤤ۤΥեå
    TF1* g1 = new TF1("g1","gaus",lowfitxmin,lowfitxmax);
    // ⤤ۤΥեå
    TF1* g2 = new TF1("g2","gaus",highfitxmin,highfitxmax);


    //ʬեåȤƥѥ᡼
    H1Dvdivide[ i ]->Fit(g1,"q0r");
    H1Dvdivide[ i ]->Fit(g2,"q0r+");
    g1->GetParameters(&par[0]);
    g2->GetParameters(&par[3]);

    //ΤΥեå
    TF1* total = new TF1("total","gaus(0)+gaus(3)",lowfitxmin,highfitxmax);
    total->SetParameters( par );
    total->SetLineWidth( 1 );
    H1Dvdivide[ i ]->Fit(total,"q");


    // ⤤ۤΥեåȤ礭Ϥ߽ФƤʤȤΤ
    // ץåȤоݤȤ.ͤϷǤ
    if ( goodfit( total->GetParameters(), total->GetParErrors() ) ) {
      nHt[ nptHCTI ] = ((hpitch-1)/2.0) + hpitch*i;
      //nHt_e[ nptHCTI ] = (hpitch-1)/2.0;
      nHt_e[ nptHCTI ] = 0.0;
      adcV[ nptHCTI ] = total -> GetParameter( 4 );      // Mean
      adcV_e[ nptHCTI ] = total -> GetParError( 4 );     // Mean Error
      nptHCTI ++;
    }


    CVvdivide.Modified();
    CVvdivide.Update();
  }




  //ΰžȤΰǴ¬줿ADCȤץåȤ
  CVcti.cd(2);
  gPad -> DrawFrame( 0.0, 0.0, 256.0, 500.0 );
  TH1F* hframe = (TH1F*)( gPad -> FindObject( "hframe" ) );
  hframe->GetXaxis() -> SetTitle( "Average Horizontal Transfer" );
  hframe->GetXaxis() -> CenterTitle();
  hframe->GetXaxis() -> SetNoExponent();
  //hframe.GetXaxis() -> SetTitleOffset( 1.2 );
  hframe->GetYaxis() -> SetTitle( "Pulseheight (ADU)" );
  hframe->GetYaxis() -> CenterTitle();
  hframe->GetYaxis() -> SetNoExponent();
  hframe->SetTitle( "Horizontal Charge Transfer Inefficiency" );

  TGraphErrors GEHCTI( nptHCTI, nHt, adcV, nHt_e, adcV_e );
  GEHCTI.SetName( "GEHCTI" );
  GEHCTI.Draw( "p" );
  TF1 myfitHCTI( "myfitHCTI", "[0] * pow( ( 1.0 - [ 1 ] ), x )", 0.0, 512.0 );
  myfitHCTI.SetParameters( 350.0, 0.0 );
  myfitHCTI.SetParNames( "Q0", "HCTI" );
  GEHCTI.Fit( "myfitHCTI", "qm" );

  Tdouble Q0H = myfitHCTI.GetParameter( 0 );
  Tdouble Q0H_e = myfitHCTI.GetParError( 0 );
  Tdouble HCTI = myfitHCTI.GetParameter( 1 );
  Tdouble HCTI_e = myfitHCTI.GetParError( 1 );
  Tstring myfitHCTItitle = myfitHCTI.GetTitle();








  //==================================================================
  //                                         ________
  // ˥ե졼ʬ䤷VCTI   |________|
  //                                        |________|
  //                                        |________|
  //                                        |________|
  //
  //==================================================================
  //ΰʬΥҥȤäɽ
  TH1D** H1Dhdivide = new TH1D*[ hdivide ];
  for ( Tint i = 0; i < hdivide; i ++ ) {
    Tstring name = "H1Dhdivide" + itostr( i, 3 );
    Tstring title = "Horizontal Partition(for VCTI): " + itostr( i, 0 );

    H1Dhdivide[ i ] = new TH1D( name.c_str(), title.c_str(), 100, 0.0, 500.0 );

    H1Dhdivide[ i ] -> GetXaxis()->SetTitle("Pulseheight (ADU)");
    H1Dhdivide[ i ] -> GetXaxis()->CenterTitle();
    H1Dhdivide[ i ] -> GetXaxis()->SetNoExponent();
    H1Dhdivide[ i ] -> GetYaxis()->SetTitle("Counts");
    H1Dhdivide[ i ] -> GetYaxis()->CenterTitle();
  }
  for ( Tsize_t i = 0; i < splist.size(); i ++ ) {
    Tint v = splist[ i ].GetVerticalID();
    Tdouble s = splist[ i ].GetSignal();
    H1Dhdivide[ v/vpitch ] -> Fill( s );
  }

  TCanvas CVhdivide( "CVhdivide", "Divide Horizontal Direction for VCTI", 960, 720 );
  CVhdivide.ToggleEventStatus();
  CVhdivide.Divide( 4, 4 );

  Tdouble* nVt = new Tdouble[ hdivide ];       // ľžβ
  Tdouble* nVt_e = new Tdouble[ hdivide ];     // ľžΥ顼
  Tdouble* adcH = new Tdouble[ hdivide ];      // ڤäϰϤǤADC濴
  Tdouble* adcH_e = new Tdouble[ hdivide ];    // ADCΥ顼
  for ( Tint i = 0; i < hdivide; i ++ ) {
    CVhdivide.cd( i + 1 );

    Tdouble par[ 6 ];
    // 㤤ۤΥեå
    TF1* g1 = new TF1("g1","gaus",lowfitxmin,lowfitxmax);
    // ⤤ۤΥեå
    TF1* g2 = new TF1("g2","gaus",highfitxmin,highfitxmax);


    //ʬեåȤƥѥ᡼
    H1Dhdivide[ i ]->Fit(g1,"q0r");
    H1Dhdivide[ i ]->Fit(g2,"q0r+");
    g1->GetParameters(&par[0]);
    g2->GetParameters(&par[3]);

    //ΤΥեå
    TF1* total = new TF1("total","gaus(0)+gaus(3)",lowfitxmin,highfitxmax);
    total->SetParameters( par );
    total->SetLineWidth( 1 );
    H1Dhdivide[ i ]->Fit(total,"q");


    // ⤤ۤΥեåȤ礭Ϥ߽ФƤʤȤΤ
    // ץåȤоݤȤ.ͤϷǤ
    if ( goodfit( total->GetParameters(), total->GetParErrors() ) ) {
      nVt[ nptVCTI ] = ((vpitch-1)/2.0) + vpitch*i;
      //nVt_e[ nptVCTI ] = (vpitch-1)/2.0;
      nVt_e[ nptVCTI ] = 0.0;
      adcH[ nptVCTI ] = total -> GetParameter( 4 );    // Mean
      adcH_e[ nptVCTI ] = total -> GetParError( 4 );   // Mean Error
      nptVCTI ++;
    }

    CVhdivide.Modified();
    CVhdivide.Update();
  }


  //ΰžȤΰǴ¬줿ADCȤץåȤ
  CVcti.cd(4);
  gPad -> DrawFrame( 0.0, 0.0, 256.0, 500.0 );
  hframe = (TH1F*)( gPad -> FindObject( "hframe" ) );
  hframe->GetXaxis() -> SetTitle( "Average Vertical Transfer" );
  hframe->GetXaxis() -> CenterTitle();
  hframe->GetXaxis() -> SetNoExponent();
  //hframe.GetXaxis() -> SetTitleOffset( 1.2 );
  hframe->GetYaxis() -> SetTitle( "Pulseheight (ADU)" );
  hframe->GetYaxis() -> CenterTitle();
  hframe->GetYaxis() -> SetNoExponent();
  hframe->SetTitle( "Vertical Charge Transfer Inefficiency" );


  TGraphErrors GEVCTI( nptVCTI, nVt, adcH, nVt_e, adcH_e );
  GEVCTI.SetName( "GEVCTI" );
  GEVCTI.Draw( "p" );
  TF1 myfitVCTI( "myfitVCTI", "[0] * pow( ( 1.0 - [ 1 ] ), x )", 0.0, 512.0 );
  myfitVCTI.SetParameters( 350.0, 0.0 );
  myfitVCTI.SetParNames( "Q0", "VCTI" );
  GEVCTI.Fit( "myfitVCTI", "qm" );

  Tdouble Q0V = myfitVCTI.GetParameter( 0 );
  Tdouble Q0V_e = myfitVCTI.GetParError( 0 );
  Tdouble VCTI = myfitVCTI.GetParameter( 1 );
  Tdouble VCTI_e = myfitVCTI.GetParError( 1 );
  Tstring myfitVCTItitle = myfitVCTI.GetTitle();





  //==================================================================
  //
  // SUMMARY
  //
  //==================================================================
  TPaveText PTsum( 0.0, 0.0, 1.0, 1.0 );
  PTsum.SetFillColor( 10 );
  PTsum.SetFillStyle( 0 );
  PTsum.SetBorderSize( 0 );
  PTsum.SetTextAlign( 12 );
  //PTainfo.SetTextSize( 0.06 );
  TstringList summary;
  summary.push_back( "FILE: " + dataset );
  summary.push_back( "ST02_CTI_HDIVIDE: " + itostr( hdivide,0 ) );
  summary.push_back( "ST02_CTI_VDIVIDE: " + itostr( vdivide,0 ) );

  summary.push_back( "Divide Vertical " + itostr( vdivide, 0 ) + " Region" );
  summary.push_back( "  #Rightarrow Function: " + myfitHCTItitle );
  summary.push_back( "  #Rightarrow Q: " + dtostr( Q0H ) + " #pm " + dtostr( Q0H_e ) );
  summary.push_back( "  #Rightarrow HCTI: " + dtostr( HCTI ) + " #pm " + dtostr( HCTI_e ) );
  summary.push_back( "Divide Horizontal " + itostr( hdivide, 0 ) + " Region" );
  summary.push_back( "  #Rightarrow Function: " +  myfitVCTItitle );
  summary.push_back( "  #Rightarrow Q: " + dtostr( Q0V ) + " #pm " + dtostr( Q0V_e ) );
   summary.push_back( "  #Rightarrow VCTI: " + dtostr( VCTI ) + " #pm " + dtostr( VCTI_e ) );

  for ( Tsize_t i = 0; i < summary.size(); i ++ ) {
    PTsum.AddText( summary[ i ].c_str() );
  }
  PTsum.AddText( "" );
  CVcti.cd( 3 );
  PTsum.Draw();

  CVcti.cd();
  CVcti.Modified();
  CVcti.Update();




  //
  // % ../../../bin/OFFcti /xxx/xxx/xxx.dat 1
  if ( isprint ) {
    CVcti.Print( "CTIspselect.ps" );
    CVcti.Print( "CTIspselect.gif" );
    CVcti.Print( "CTIspselect.C" );
    CVcti.Print( "CTIspselect.root" );
    CVvdivide.Print( "CTIvdivide.ps" );
    CVvdivide.Print( "CTIvdivide.gif" );
    CVvdivide.Print( "CTIvdivide.C" );
    CVvdivide.Print( "CTIvdivide.root" );
    CVhdivide.Print( "CTIhdivide.ps" );
    CVhdivide.Print( "CTIhdivide.gif" );
    CVhdivide.Print( "CTIhdivide.C" );
    CVhdivide.Print( "CTIhdivide.root" );
  }

  theApplication -> Run();
  return( 0 );
}

Tbool goodfit( Tdouble par[], Tdouble pare[] )
{
  //Tdouble Lhist_const = par[0];
  //Tdouble Lhist_mean = par[1];
  //Tdouble Lhist_sigma = par[2];
  //Tdouble Hhist_const = par[3];
  Tdouble Hhist_mean = par[4];
  //Tdouble Hhist_sigma = par[5];

  //Tdouble Lhist_const_e = pare[0];
  //Tdouble Lhist_mean_e = pare[1];
  //Tdouble Lhist_sigma_e = pare[2];
  //Tdouble Hhist_const_e = pare[3];
  Tdouble Hhist_mean_e = pare[4];
  //Tdouble Hhist_sigma_e = pare[5];

  Tbool retval = Ttrue;
  //retval &= ( Lhist_mean > 0.0 );
  //retval &= ( Lhist_mean < 300.0 );
  retval &= ( Hhist_mean > highfitxmin );
  retval &= ( Hhist_mean < highfitxmax );
  retval &= ( Hhist_mean_e < Hhist_mean * 0.05 ); // 顼5%̤

  return( retval );
}
