// =====================================================================
//  $Id: St02Map.hh,v 1.2 2003/07/30 16:16:34 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: St02Map.hh,v $
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST02MAP_HH
#define __ST02MAP_HH

#include "Tglobals.h"
#include "TDataMultiplicity.hh"
#include "TEnvironmentVariableTable.hh"

enum Tpixel_t {
  tBlank, 
  tOpticalBlack, 
  tSignal, 
  tHoc,
  tDummy,
  tVerticalShift,
  tIgnore, 
  tEndOfHoc
};

class St02Map
{

  protected:
    TEnvironmentVariableTable theEnvironmentVariableTable;
    Tint theNumberOfHorizontalPixels;
    Tint theNumberOfVerticalPixels;
    Tint theHorizontalOffset;
    Tint theVerticalOffset;
    Tint theRateOfVerticalShift;
    Tint theNumberOfHorizontalOverClockPixels;
    Tstring theInputFileName;
    Tdouble theHOCbuffer;
    TDataMultiplicity theMap;
    TdoubleList theHOCaverage;

  protected:
    St02Map( const Tstring& filename );
    virtual ~St02Map();

  public:
    Tint GetNumberOfHorizontalPixels() const;
    Tint GetNumberOfVerticalPixels() const;
    Tint GetHorizontalOffset() const;
    Tint GetVerticalOffset() const;
    Tint GetRateOfVerticalShift() const;
    const Tstring& GetInputFileName() const;
    const TDataMultiplicity& GetMap() const;
    TDataMultiplicity& GetMap();
    const TEnvironmentVariableTable& GetEnvironmentVariableTable() const;
    TEnvironmentVariableTable& GetEnvironmentVariableTable();
    const TdoubleList& GetHOCaverage() const;

  public:
    Tpixel_t IsThisPixel( Tint dataid ) const;
    virtual Tvoid FillMap( Tshort* data, Tint ndata );

};

inline Tint St02Map::GetNumberOfHorizontalPixels() const
{
  return( theNumberOfHorizontalPixels );
}

inline Tint St02Map::GetNumberOfVerticalPixels() const
{
  return( theNumberOfVerticalPixels );
}

inline Tint St02Map::GetHorizontalOffset() const
{
  return( theHorizontalOffset );
}

inline Tint St02Map::GetVerticalOffset() const
{
  return( theVerticalOffset );
}

inline Tint St02Map::GetRateOfVerticalShift() const
{
  return( theRateOfVerticalShift );
}

inline const Tstring& St02Map::GetInputFileName() const
{
  return( theInputFileName );
}

inline const TDataMultiplicity& St02Map::GetMap() const
{
  return( theMap );
}

inline TDataMultiplicity& St02Map::GetMap()
{
  return( theMap );
}

inline const TEnvironmentVariableTable& St02Map::GetEnvironmentVariableTable() const
{
  return( theEnvironmentVariableTable );
}

inline TEnvironmentVariableTable& St02Map::GetEnvironmentVariableTable()
{
  return( theEnvironmentVariableTable );
}

inline const TdoubleList& St02Map::GetHOCaverage() const
{
  return( theHOCaverage );
}

#endif
