// =====================================================================
//  $Id: St02RunSummary.hh,v 1.2 2003/07/30 16:16:35 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: St02RunSummary.hh,v $
//  Revision 1.2  2003/07/30 16:16:35  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST02RUNSUMMARY_HH
#define __ST02RUNSUMMARY_HH

#include "TRunInformationTable.hh"
#include "TChannel.hh"

class St02RunSummary
{

  private:
    Tint theRunID;
    Tstring theRecordName;
    Tint theRecordSize;
    Tint theNumberOfEvents;
    TRunInformationTable theRunInformationTable;
    Tstring theRunBeginTime;
    Tstring theRunEndTime;
    // I wish ...
    Tdouble theTempAve;
    Tdouble theTempMax;
    Tdouble theTempMin;
    Tdouble theDarkAve;
    Tdouble theDarkMax;
    Tdouble theDarkMin;
    Tdouble theSignalAve;
    Tdouble theSignalMax;
    Tdouble theSignalMin;
    Tdouble theHocAve;

  public:
    St02RunSummary();
    ~St02RunSummary();

  public:
    TRunInformationTable GenerateRunSummaryTable() const;
    Tvoid Initialize();

  public:
    Tint GetRunID() const;
    const Tstring& GetRecordName() const;
    Tint GetRecordSize() const;
    Tint GetNumberOfEvents() const;
    const TRunInformationTable& GetRunInformationTable() const;
    const Tstring& GetRunBeginTime() const;
    const Tstring& GetRunEndTime() const;
    Tvoid SetRunID( Tint runid );
    Tvoid SetRecordName( const Tstring& recname );
    Tvoid SetRecordSize( Tint size );
    Tvoid SetNumberOfEvents( Tint nevents );
    Tvoid SetRunInformationTable( const TRunInformationTable& table );
    Tvoid SetRunBeginTime( const Tstring& time );
    Tvoid SetRunEndTime( const Tstring& time );

    Tdouble GetTempAve() const;
    Tdouble GetTempMax() const;
    Tdouble GetTempMin() const;
    Tdouble GetDarkAve() const;
    Tdouble GetDarkMax() const;
    Tdouble GetDarkMin() const;
    Tdouble GetSignalAve() const;
    Tdouble GetSignalMax() const;
    Tdouble GetSignalMin() const;
    Tdouble GetHocAve() const;
    Tvoid SetTempAve( Tdouble temp );
    Tvoid SetTempMax( Tdouble temp );
    Tvoid SetTempMin( Tdouble temp );
    Tvoid SetDarkAve( Tdouble dark );
    Tvoid SetDarkMax( Tdouble dark );
    Tvoid SetDarkMin( Tdouble dark );
    Tvoid SetSignalAve( Tdouble signal );
    Tvoid SetSignalMax( Tdouble signal );
    Tvoid SetSignalMin( Tdouble signal );
    Tvoid SetHocAve( Tdouble hoc );

};

inline Tint St02RunSummary::GetRunID() const
{
  return( theRunID );
}

inline const Tstring& St02RunSummary::GetRecordName() const
{
  return( theRecordName );
}

inline Tint St02RunSummary::GetRecordSize() const
{
  return( theRecordSize );
}

inline Tint St02RunSummary::GetNumberOfEvents() const
{
  return( theNumberOfEvents );
}

inline const TRunInformationTable& St02RunSummary::GetRunInformationTable() const
{
  return( theRunInformationTable );
}

inline const Tstring& St02RunSummary::GetRunBeginTime() const
{
  return( theRunBeginTime );
}

inline const Tstring& St02RunSummary::GetRunEndTime() const
{
  return( theRunEndTime );
}

inline Tvoid St02RunSummary::SetRunID( Tint runid )
{
  theRunID = runid;
  return;
}

inline Tvoid St02RunSummary::SetRecordName( const Tstring& recname )
{
  theRecordName = recname;
  return;
}

inline Tvoid St02RunSummary::SetRecordSize( Tint size )
{
  theRecordSize = size;
  return;
}

inline Tvoid St02RunSummary::SetNumberOfEvents( Tint nevents )
{
  theNumberOfEvents = nevents;
  return;
}

inline Tvoid St02RunSummary::SetRunInformationTable( const TRunInformationTable& table )
{
  theRunInformationTable = table;
  return;
}

inline Tvoid St02RunSummary::SetRunBeginTime( const Tstring& time )
{
  theRunBeginTime = time;
  return;
}

inline Tvoid St02RunSummary::SetRunEndTime( const Tstring& time )
{
  theRunEndTime = time;
  return;
}

inline Tdouble St02RunSummary::GetTempAve() const
{
  return( theTempAve );
}

inline Tdouble St02RunSummary::GetTempMax() const
{
  return( theTempMax );
}

inline Tdouble St02RunSummary::GetTempMin() const
{
  return( theTempMin );
}

inline Tdouble St02RunSummary::GetDarkAve() const
{
  return( theDarkAve );
}

inline Tdouble St02RunSummary::GetDarkMax() const
{
  return( theDarkMax );
}

inline Tdouble St02RunSummary::GetDarkMin() const
{
  return( theDarkMin );
}

inline Tdouble St02RunSummary::GetSignalAve() const
{
  return( theSignalAve );
}

inline Tdouble St02RunSummary::GetSignalMax() const
{
  return( theSignalMax );
}

inline Tdouble St02RunSummary::GetSignalMin() const
{
  return( theSignalMin );
}

inline Tdouble St02RunSummary::GetHocAve() const
{
  return( theHocAve );
}

inline Tvoid St02RunSummary::SetTempAve( Tdouble temp )
{
  theTempAve = temp;
  return;
}

inline Tvoid St02RunSummary::SetTempMax( Tdouble temp )
{
  theTempMax = temp;
  return;
}

inline Tvoid St02RunSummary::SetTempMin( Tdouble temp )
{
  theTempMin = temp;
  return;
}

inline Tvoid St02RunSummary::SetDarkAve( Tdouble dark )
{
  theDarkAve = dark;
  return;
}

inline Tvoid St02RunSummary::SetDarkMax( Tdouble dark )
{
  theDarkMax = dark;
  return;
}

inline Tvoid St02RunSummary::SetDarkMin( Tdouble dark )
{
  theDarkMin = dark;
  return;
}

inline Tvoid St02RunSummary::SetSignalAve( Tdouble signal )
{
  theSignalAve = signal;
  return;
}

inline Tvoid St02RunSummary::SetSignalMax( Tdouble signal )
{
  theSignalMax = signal;
  return;
}

inline Tvoid St02RunSummary::SetSignalMin( Tdouble signal )
{
  theSignalMin = signal;
  return;
}

inline Tvoid St02RunSummary::SetHocAve( Tdouble hoc )
{
  theHocAve = hoc;
  return;
}

#endif
