// =====================================================================
//  $Id: TSetRunInformationModuleCommand.cc,v 1.2 2003/07/30 16:17:32 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: TSetRunInformationModuleCommand.cc,v $
//  Revision 1.2  2003/07/30 16:17:32  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TSetRunInformationModuleCommand.hh"
#include "TRunManager.hh"
#include "TSoftwareRunInformationModule.hh"
#include "TRunInformationTable.hh"
#include "TUserInterface.hh"

static const Tstring _name = "/run/setinfo";
static const Tstring _desc = "set run information into the table.";

TSetRunInformationModuleCommand::TSetRunInformationModuleCommand( TRunManager* manager, TSoftwareRunInformationModule* module )
  : TCommand( manager, _name, _desc ), TRunInformationModuleCommand( module )
{;}

TSetRunInformationModuleCommand::~TSetRunInformationModuleCommand()
{;}

Tvoid TSetRunInformationModuleCommand::Execute( const TstringList& arguments )
{
  if ( theRunInformationModule == 0 ) {
    return;
  }

  TRunInformationTable& table =
    theRunInformationModule -> GetRunInformationTable();

  if ( arguments.empty() ) {
    table.SetRunInformation();
  } else if ( arguments.size() == 1 ) {
    table.SetRunInformation( arguments[ 0 ] );
  } else if ( arguments.size() == 2 ) {
    table.SetRunInformation( arguments[ 0 ], arguments[ 1 ] );
  } else {
    ShowCommandDetail();
  }
  return;
}
