// =====================================================================
//  $Id: TEvent.cc,v 1.2 2003/07/30 16:18:09 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: TEvent.cc,v $
//  Revision 1.2  2003/07/30 16:18:09  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TEvent.hh"

TEvent::TEvent( Tint eventID )
  : theEventID( eventID ), theDataRecord()
{;}

TEvent::TEvent( const TDataRecord& eventData )
  : theEventID( 0 ), theDataRecord( eventData )
{;}

TEvent::TEvent( Tint eventID, const TDataRecord& eventData )
  : theEventID( eventID ), theDataRecord( eventData )
{;}

TEvent::TEvent( const TEvent& right )
  : theEventID( right.theEventID ), 
    theDataRecord( right.theDataRecord )
{;}

TEvent::~TEvent()
{;}

const TEvent& TEvent::operator=( const TEvent& right )
{
  theEventID = right.theEventID;
  theDataRecord = right.theDataRecord;
  return( *this );
}

Tbool TEvent::operator==( const TEvent& right ) const
{
  if ( theEventID == right.theEventID && theDataRecord == right.theDataRecord ) {
    return( Ttrue );
  } else {
    return( Tfalse );
  }
}

Tbool TEvent::operator!=( const TEvent& right ) const
{
  if ( theEventID != right.theEventID || theDataRecord != right.theDataRecord ) {
    return( Ttrue );
  } else {
    return( Tfalse );
  }
}

Tvoid TEvent::Clear()
{
  theDataRecord.Clear();
  theEventID = 0;
  return;
}

Tstring TEvent::GetStringEventID( Tint digits ) const
{
  return( itostr( theEventID, digits ) );
}
