// =====================================================================
//  $Id: TOutputObjectSocket.hh,v 1.2 2003/07/30 16:19:31 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: TOutputObjectSocket.hh,v $
//  Revision 1.2  2003/07/30 16:19:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TOUTPUTOBJECTSOCKET_HH
#define __TOUTPUTOBJECTSOCKET_HH

#include "Tglobals.h"
#include "TObjectSocket.hh"
#include "TOutputObjectStream.hh"

class TStreamableObject;
class TObjectFilter;

class TOutputObjectSocket
  : public TObjectSocket, public TOutputObjectStream
{

  private:
    Tstring theServerName;
    struct hostent* theHostInformation;

  public:
    TOutputObjectSocket( const Tstring& hostname = "localhost", Tint port = tDefaultPortNumber );
    TOutputObjectSocket( Tint port );
    TOutputObjectSocket( TObjectFilter* filter, const Tstring& hostname = "localhost", Tint port = tDefaultPortNumber );
    TOutputObjectSocket( TObjectFilter* filter, Tint port );
    ~TOutputObjectSocket();

  public:
    Tint Write( TStreamableObject& object );

  public:
    const Tstring& GetServerName() const;

  private:
    Tvoid initialize();

};

inline const Tstring& TOutputObjectSocket::GetServerName() const
{
  return( theServerName );
}

#endif
