// =====================================================================
//  $Id: sm2400.cc,v 1.2 2003/07/30 16:21:39 goiwai Exp $
//  $Name: CLDAQ-1-07-01 $
//
//  $Log: sm2400.cc,v $
//  Revision 1.2  2003/07/30 16:21:39  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TRs232cKeithley2400Module.hh"
#include "TDataElement.hh"
#include "TBenchmark.hh"

int main( int argc, char** argv, char** envv )
{
  if ( argc != 2 ) {
    Tcerr << "usage: " << argv[ 0 ] << Tspace << "<device>" << Tendl;
    Tcerr << "ex) " << argv[ 0 ] << " /dev/ttyS0 (linux typical)" << Tendl;
    return( -1 );
  }
  const Tstring devpath = argv[ 1 ];
  const Tint nevent = 10;
  TRs232cKeithley2400Module sm2400;
  sm2400.Initialize();
  TDataElement e;

  TBenchmark bench;
  bench.Start();
  for ( Tint i = 0; i < nevent; i ++ ) {
    sm2400.FillData( e, 0 );
    sm2400.Clear();
    Tcout << e << Tendl;
    sleep( 1 );
  }
  sm2400.Close();
  bench.Stop();
  Tcout << bench << Tendl;
  return( 0 );
}
