// =====================================================================
//  $Id: St01Map.hh,v 1.3 2003/07/30 16:16:11 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: St01Map.hh,v $
//  Revision 1.3  2003/07/30 16:16:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __ST01MAP_HH
#define __ST01MAP_HH

#include "Tglobals.h"
#include "TDataMultiplicity.hh"
#include "TEnvironmentVariableTable.hh"

enum Tpixel_t {
  tBlank, 
  tOpticalBlack, 
  tSignal, 
  tHoc,
  tDummy,
  tVerticalShift,
  tIgnore, 
  tEndOfHoc
};

class St01Map
{

  protected:
    TEnvironmentVariableTable theEnvironmentVariableTable;
    Tint theNumberOfHorizontalPixels;
    Tint theNumberOfVerticalPixels;
    Tint theHorizontalOffset;
    Tint theVerticalOffset;
    Tint theRateOfVerticalShift;
    Tint theNumberOfHorizontalOverClockPixels;
    Tstring theInputFileName;
    Tdouble theHOCbuffer;
    TDataMultiplicity theMap;
    TdoubleList theHOCaverage;

  protected:
    St01Map( const Tstring& filename );
    virtual ~St01Map();

  public:
    Tint GetNumberOfHorizontalPixels() const;
    Tint GetNumberOfVerticalPixels() const;
    Tint GetHorizontalOffset() const;
    Tint GetVerticalOffset() const;
    Tint GetRateOfVerticalShift() const;
    const Tstring& GetInputFileName() const;
    const TDataMultiplicity& GetMap() const;
    TDataMultiplicity& GetMap();
    const TEnvironmentVariableTable& GetEnvironmentVariableTable() const;
    TEnvironmentVariableTable& GetEnvironmentVariableTable();
    const TdoubleList& GetHOCaverage() const;

  public:
    Tpixel_t IsThisPixel( Tint dataid ) const;
    virtual Tvoid FillMap( Tshort* data, Tint ndata );

};

inline Tint St01Map::GetNumberOfHorizontalPixels() const
{
  return( theNumberOfHorizontalPixels );
}

inline Tint St01Map::GetNumberOfVerticalPixels() const
{
  return( theNumberOfVerticalPixels );
}

inline Tint St01Map::GetHorizontalOffset() const
{
  return( theHorizontalOffset );
}

inline Tint St01Map::GetVerticalOffset() const
{
  return( theVerticalOffset );
}

inline Tint St01Map::GetRateOfVerticalShift() const
{
  return( theRateOfVerticalShift );
}

inline const Tstring& St01Map::GetInputFileName() const
{
  return( theInputFileName );
}

inline const TDataMultiplicity& St01Map::GetMap() const
{
  return( theMap );
}

inline TDataMultiplicity& St01Map::GetMap()
{
  return( theMap );
}

inline const TEnvironmentVariableTable& St01Map::GetEnvironmentVariableTable() const
{
  return( theEnvironmentVariableTable );
}

inline TEnvironmentVariableTable& St01Map::GetEnvironmentVariableTable()
{
  return( theEnvironmentVariableTable );
}

inline const TdoubleList& St01Map::GetHOCaverage() const
{
  return( theHOCaverage );
}

#endif
