// =====================================================================
//  $Id: St01SinglePixel.cc,v 1.2 2003/07/30 16:16:11 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: St01SinglePixel.cc,v $
//  Revision 1.2  2003/07/30 16:16:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "St01SinglePixel.hh"

St01SinglePixel::St01SinglePixel( Tint h, Tint v, Tdouble signal, Tdouble dark, Tdouble rms )
  : theHorizontalID( h ), theVerticalID( v ),
    theSignal( signal ), theDark( dark ), theRms( rms )
{;}

St01SinglePixel::St01SinglePixel( const St01SinglePixel& right )
  : theHorizontalID( right.theHorizontalID ),
    theVerticalID( right.theVerticalID ),
    theSignal( right.theSignal ),
    theDark( right.theDark ),
    theRms( right.theRms )
{;}

St01SinglePixel::~St01SinglePixel()
{;}

const St01SinglePixel& St01SinglePixel::operator=( const St01SinglePixel& right )
{
  theHorizontalID = right.theHorizontalID;
  theVerticalID = right.theVerticalID;
  theSignal = right.theSignal;
  theDark = right.theDark;
  theRms = right.theRms;
  return( *this );
}

Tbool St01SinglePixel::operator==( const St01SinglePixel& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( theHorizontalID == right.theHorizontalID );
  retval &= ( theVerticalID == right.theVerticalID );
  retval &= ( theSignal == right.theSignal );
  retval &= ( theDark == right.theDark );
  retval &= ( theRms == right.theRms );
  return( retval );
}

Tbool St01SinglePixel::operator!=( const St01SinglePixel& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( theHorizontalID != right.theHorizontalID );
  retval |= ( theVerticalID != right.theVerticalID );
  retval |= ( theSignal != right.theSignal );
  retval |= ( theDark != right.theDark );
  retval |= ( theRms != right.theRms );
  return( retval );
}

Tostream& operator<<( Tostream& tos, const St01SinglePixel& right )
{
  tos << right.theHorizontalID << Tspace;
  tos << right.theVerticalID << Tspace;
  tos << right.theSignal << Tspace;
  tos << right.theDark << Tspace;
  tos << right.theRms << Tflush;
  return( tos );
}

Tistream& operator>>( Tistream& tis, St01SinglePixel& right )
{
  return( tis >> right.theHorizontalID >> right.theVerticalID >> right.theSignal >> right.theDark >> right.theRms );
}
