// =====================================================================
//  $Id: St02RunInformationExtractor.cc,v 1.2 2003/07/30 16:16:34 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: St02RunInformationExtractor.cc,v $
//  Revision 1.2  2003/07/30 16:16:34  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "St02RunInformationExtractor.hh"
#include "TInputObjectFile.hh"
#include "TDataRecord.hh"
#include "TDataSegment.hh"
#include "TDataElement.hh"

St02RunInformationExtractor::St02RunInformationExtractor( const Tstring& recpath )
  : theRecordPath( recpath ), theElementTags(), theElements()
{
  theElementTags.push_back( "RECORD PATH" );
  theElements.push_back( theRecordPath );

  if ( isexist( theRecordPath ) ) {
    TInputObjectFile input( theRecordPath );
    TDataRecord runbegin;
    input >> runbegin;
    if ( runbegin.GetID() == "RUN BEGIN" ) {
      Tint runid = *( runbegin[0][0][0].GetIntData() );
      theElementTags.push_back( "RUN ID" );
      theElements.push_back( itostr( runid ) );
      TDataSegment seginfo = runbegin[0][1];
      for ( Tsize_t i = 0; i < seginfo.size(); i ++ ) {
        TDataElement e = seginfo[ i ];
        theElementTags.push_back( e.GetID() );
        theElements.push_back( *( e.GetStringData() ) );
      }
      TDataElement eleclock = runbegin[0][2][0];
      theElementTags.push_back( "CLOCK" );
      theElements.push_back( *( eleclock.GetStringData() ) );
    } else {
      theElementTags.push_back( "ERROR" );
      theElements.push_back( "No RUN BEGIN record." );
    }
  } else {
    theElementTags.push_back( "ERROR" );
    theElements.push_back( "No such a file." );
  }
}

St02RunInformationExtractor::~St02RunInformationExtractor()
{;}

Tostream& operator<<( Tostream& tos, const St02RunInformationExtractor& right )
{
  for ( Tsize_t i = 0; i < right.theElementTags.size(); i ++ ) {
    tos << right.theElementTags[ i ] << ": " << right.theElements[ i ] << Tendl;
  }
  return( tos );
}
