// =====================================================================
//  $Id: TCommandSpecified.cc,v 1.2 2003/07/30 16:17:31 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: TCommandSpecified.cc,v $
//  Revision 1.2  2003/07/30 16:17:31  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#include "TCommandSpecified.hh"

TCommandSpecified::TCommandSpecified()
  : theName(), 
    theFullName(), 
    theAbsolutePath(), 
    theDirectoryDepth( tNotDefineDepth ), 
    theBuiltinFlag( Tfalse ), 
    theCommand( 0 )
{;}

TCommandSpecified::TCommandSpecified( const Tstring& name, const Tstring& fullname, const Tstring& path, Tint depth, Tbool flag, TCommand* command )
  : theName( name ), 
    theFullName( fullname ), 
    theAbsolutePath( path ), 
    theDirectoryDepth( depth ), 
    theBuiltinFlag( flag ), 
    theCommand( command )
{;}

TCommandSpecified::TCommandSpecified( const TCommandSpecified& right )
  : theName( right.theName ), 
    theFullName( right.theFullName ), 
    theAbsolutePath( right.theAbsolutePath ), 
    theDirectoryDepth( right.theDirectoryDepth ), 
    theBuiltinFlag( right.theBuiltinFlag ), 
    theCommand( right.theCommand )
{;}

TCommandSpecified::~TCommandSpecified()
{;}

const TCommandSpecified& TCommandSpecified::operator=( const TCommandSpecified& right )
{
  theName = right.theName;
  theFullName = right.theFullName;
  theAbsolutePath = right.theAbsolutePath;
  theDirectoryDepth = right.theDirectoryDepth;
  theBuiltinFlag = right.theBuiltinFlag;
  theCommand = right.theCommand;
  return( *this );
}

Tbool TCommandSpecified::operator==( const TCommandSpecified& right ) const
{
  Tbool retval = Ttrue;
  retval &= ( theName == right.theName );
  retval &= ( theFullName == right.theFullName );
  retval &= ( theAbsolutePath == right.theAbsolutePath );
  retval &= ( theDirectoryDepth == right.theDirectoryDepth );
  retval &= ( theBuiltinFlag == right.theBuiltinFlag );
  retval &= ( theCommand == right.theCommand );
  return( retval );
}

Tbool TCommandSpecified::operator!=( const TCommandSpecified& right ) const
{
  Tbool retval = Tfalse;
  retval |= ( theName != right.theName );
  retval |= ( theFullName != right.theFullName );
  retval |= ( theAbsolutePath != right.theAbsolutePath );
  retval |= ( theDirectoryDepth != right.theDirectoryDepth );
  retval |= ( theBuiltinFlag != right.theBuiltinFlag );
  retval |= ( theCommand != right.theCommand );
  return( retval );
}

Tostream& operator<<( Tostream& tos, const TCommandSpecified& right )
{
  if ( right.theBuiltinFlag ) {
    tos << right.theName << ": Builtin command, ";
    tos << right.theCommand << Tflush;
  } else {
    tos << right.theFullName << ": [" << right.theName << "] in ";
    tos << right.theAbsolutePath;
    tos << " directory(Lv." << right.theDirectoryDepth << "), ";
    tos << right.theCommand << Tflush;
  }
  return( tos );
}
