// =====================================================================
//  $Id: TSoftwareDataFileModule.hh,v 1.2 2003/07/30 16:19:11 goiwai Exp $
//  $Name: CLDAQ-1-08-00 $
//
//  $Log: TSoftwareDataFileModule.hh,v $
//  Revision 1.2  2003/07/30 16:19:11  goiwai
//  ե˥ߥåȥĤ뤳Ȥˤޤ.
//
// =====================================================================
#ifndef __TSOFTWAREDATAFILEMODULE_HH
#define __TSOFTWAREDATAFILEMODULE_HH

#include "Tglobals.h"
#include "TSoftwareModule.hh"

class TDataSegment;
class TDataElement;

class TSoftwareDataFileModule
  : public TSoftwareModule
{

  private:
    enum { tDefaultBufferLength = 1048576 };

  private:
    Tstring theFileName;
    Tstring theSeparater;
    TdoubleList theChannel;
    Tint theBufferLength;
    Tint theNumberOfLine;
    TstringList theCommentStringList;
    Tifstream theInputFileStream;

  public:
    TSoftwareDataFileModule( const Tstring& filename, Tint nchannel );
    TSoftwareDataFileModule( const Tstring& filename, const TstringList& comment, Tint nchannel );
    TSoftwareDataFileModule( const Tstring& filename, const Tstring& separater, Tint nchannel );
    TSoftwareDataFileModule( const Tstring& filename, const TstringList& comment, const Tstring& separater, Tint nchannel );
    TSoftwareDataFileModule( const TSoftwareDataFileModule& right );
    ~TSoftwareDataFileModule();

  public:
    Tint Clear();
    Tint Update();
    Tint Initialize();

  public:
    Tvoid FillData( TDataElement& element, Tint channel );

  public:
    const TSoftwareDataFileModule& operator=( const TSoftwareDataFileModule& right );
    Tbool operator==( const TSoftwareDataFileModule& right ) const;
    Tbool operator!=( const TSoftwareDataFileModule& right ) const;

  public:
    const Tstring& GetFileName() const;
    const Tstring& GetSeparater() const;
    const TdoubleList& GetChannel() const;
    Tint GetBufferLength() const;
    const TstringList& GetCommentStringList() const;
    Tint GetNumberOfLine() const;
    Tifstream& GetInputFileStream();
    Tvoid SetFileName( const Tstring& fname );
    Tvoid SetSeparater( const Tstring& separater );
    Tvoid SetChannel( const TdoubleList& channels );
    Tvoid SetBufferLength( Tint buflen );
    Tvoid SetCommentStringList( const TstringList& commentlist );
    Tvoid SetNumberOfLine( Tint nline );

  private:
    const Tstring& eraseComment( Tstring& readline ) const;
    TdoubleList divideLine( Tstring readline ) const;
    Tint getNumberOfLine() const;

};

inline const Tstring& TSoftwareDataFileModule::GetFileName() const
{
  return( theFileName );
}

inline const Tstring& TSoftwareDataFileModule::GetSeparater() const
{
  return( theSeparater );
}

inline const TdoubleList& TSoftwareDataFileModule::GetChannel() const
{
  return( theChannel );
}

inline Tint TSoftwareDataFileModule::GetBufferLength() const
{
  return( theBufferLength );
}

inline const TstringList& TSoftwareDataFileModule::GetCommentStringList() const
{
  return( theCommentStringList );
}

inline Tint TSoftwareDataFileModule::GetNumberOfLine() const
{
  return( theNumberOfLine );
}

inline Tifstream& TSoftwareDataFileModule::GetInputFileStream()
{
  return( theInputFileStream );
}

inline Tvoid TSoftwareDataFileModule::SetFileName( const Tstring& fname )
{
  theFileName = fname;
  return;
}

inline Tvoid TSoftwareDataFileModule::SetSeparater( const Tstring& separater )
{
  theSeparater = separater;
  return;
}

inline Tvoid TSoftwareDataFileModule::SetChannel( const TdoubleList& channels )
{
  theChannel = channels;
  return;
}

inline Tvoid TSoftwareDataFileModule::SetBufferLength( Tint buflen )
{
  theBufferLength = buflen;
  return;
}

inline Tvoid TSoftwareDataFileModule::SetCommentStringList( const TstringList& commentlist )
{
  theCommentStringList = commentlist;
  return;
}

inline Tvoid TSoftwareDataFileModule::SetNumberOfLine( Tint nline )
{
  theNumberOfLine = nline;
  return;
}

#endif
